<?php
/**
 * Register form.
 *
 * @package          Flatsome\Templates
 * @flatsome-version 3.19.0
 */

if ( $args['form'] ) : ?>
<form action="<?php echo admin_url( 'admin-post.php' ); ?>" method="POST" autocomplete="off" onsubmit="return onFlatsomeRegisterForm(this);">
<?php endif; ?>

	<?php if ( $error ) : ?>
	<div class="notice notice-<?php echo is_string( $error->get_error_code() ) ? 'warning' : 'error'; ?> notice-alt inline" style="display:none!important">
		<?php echo wpautop( $error->get_error_message() ); ?>
	</div>
	<?php elseif ( ! empty( $issues ) ) : ?>
	<div class="notice notice-success notice-alt inline" style="display:block!important;margin-bottom:15px!important">
		<p><?php _e( 'وبسایت شما ثبت شده است <strong> راست چین</strong>.از ثبت لایسنس شما متشکریم ، شما میتوانید قالب را بصورت کامل استفاده نمایید.', 'flatsome' ); ?></p>
	</div>
	<?php elseif ( $registration->is_registered() && $registration->is_verified() && $code ) : ?>
	<div class="notice notice-success notice-alt inline" style="display:block!important;margin-bottom:15px!important">
		<p><?php _e( 'Your site is <strong>registered</strong>. Thank you! Enjoy Flatsome and one-click updates.', 'flatsome' ); ?></p>
	</div>
	<?php endif; ?>

	<?php wp_nonce_field( 'flatsome_envato_register', 'flatsome_envato_register_nonce' ); ?>
	<input type="hidden" name="action" value="flatsome_envato_register" />

	<div class="flatsome-registration-form">

		<?php if ( ! $registration->is_verified() && ( ! empty( get_option( flatsome_theme_key() . '_wup_purchase_code' ) ) || ! empty( get_option( 'flatsome_envato' ) ) ) ) : ?>
			<div class="wp-clearfix">
				<div class="notice notice-error notice-alt inline" style="display:block!important;margin-bottom:15px!important">
					
				</div>
			</div>
		<?php endif; ?>

	

		<?php if ( empty( $issues ) && $registration->get_option( 'domain' ) ) : ?>
		<p>
			<?php esc_html_e( 'Registered domain:', 'flatsome' ); ?>
			<b><?php echo esc_html( $registration->get_option( 'domain' ) ); ?></b>
			<?php if ( ! $registration->is_public() ) : ?>
				<code><?php echo esc_html( strtolower( $registration->get_option( 'type' ) ) ); ?></code>
			<?php endif; ?>
		</p>
		<?php endif; ?>

		<?php if ( $args['show_terms'] ) : ?>
			<p>
				
			</p>
		<?php endif; ?>

		<?php if ( $args['form'] && $args['show_submit'] ) : ?>
		<p>
			
		</p>
		<?php endif; ?>

	</div>

<?php if ( $args['form'] ) :  ?>
</form>
<?php endif; ?>

<small style="padding-top: 10px; margin-top: 15px; opacity: .8; display: block; border-top: 1px solid #eee;">
کد خرید (مجوز) فقط برای <strong>One Domain</strong> معتبر است. آیا از این موضوع در دامنه جدیدی استفاده می کنید؟ برای دریافت کد خرید جدید، یک <a href="https://www.rtl-theme.com/flatsome/" target="_blank">مجوز جدید از اینجا</a> خریداری کنید.
</small>

<script type="text/javascript">
function onFlatsomeUnregister() {
	if (!confirm("<?php echo wp_slash( __( 'Are you sure you want to unregister Flatsome?', 'flatsome' ) ) ?>")) {
		return false;
	}
}
function onFlatsomeRegisterForm(form){
	<?php if ( ! $registration->is_registered() ) : ?>
	if (!form.flatsome_envato_terms.checked) {
		form.flatsome_envato_terms.parentNode.style.color = "#dc3232";
		return false;
	}
	<?php endif; ?>
	return true;
}
</script>
