<?php

$options = array(
	'per_page' => array(
		'type'    => 'slider',
		'heading' => 'شماره',
		'default' => '12',
		'max'     => '99',
		'min'     => '4',
	),
	'columns'  => array(
		'type'    => 'slider',
		'heading' => 'ستون‌ها',
		'default' => '4',
		'max'     => '8',
		'min'     => '1',
	),
	'orderby'  => array(
		'type'    => 'select',
		'heading' => __( 'مرتب سازی براساس', 'flatsome' ),
		'default' => 'title',
		'options' => array(
			'menu_order' => 'منو سفارشی',
			'title'      => 'عنوان',
			'date'       => 'تاریخ',
			'rand'       => 'تصادفی',
			//'id' => 'ID', // Valid but Disabled
		),
	),
	'order'    => array(
		'type'    => 'select',
		'heading' => __( 'مرتب‌سازی', 'flatsome' ),
		'default' => 'asc',
		'options' => array(
			'asc'  => 'ASC',
			'desc' => 'DESC',
		),
	),
);

$options_custom = array(
	'ids'      => array(
		'type'       => 'select',
		'heading'    => 'محصولات',
		'param_name' => 'ids',
		'config'     => array(
			'multiple'    => true,
			'placeholder' => 'انتخاب...',
			'postSelect'  => array(
				'post_type' => array( 'product' ),
			),
		),
	),
	'per_page' => array(
		'type'    => 'slider',
		'heading' => 'شماره',
		'default' => '12',
		'max'     => '99',
		'min'     => '4',
	),
	'columns'  => array(
		'type'    => 'slider',
		'heading' => 'ستون‌ها',
		'default' => '4',
		'max'     => '8',
		'min'     => '1',
	),
	'orderby'  => array(
		'type'    => 'select',
		'heading' => __( 'مرتب‌سازی براساس', 'flatsome' ),
		'default' => 'title',
		'options' => array(
			'menu_order' => 'منو سفارش',
			'title'      => 'عنوان',
			'date'       => 'تاریخ',
			'rand'       => 'تصادفی',
			'price'      => 'قیمت',
			'popularity' => 'محبوبیت',
			'rating'     => 'امتیاز',
			//'id' => 'ID', // Valid but Disabled
		),
	),
	'order'    => array(
		'type'    => 'select',
		'heading' => __( 'مرتب سازی', 'flatsome' ),
		'default' => 'asc',
		'options' => array(
			'asc'  => 'صعودی',
			'desc' => 'نزولی',
		),
	),
);

add_ux_builder_shortcode( 'products',
	array(
		'name'      => 'محصولات - ستون',
		'category'  => __( 'Shop', 'flatsome' ),
		'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
		'wrap'      => false,
		'options'   => $options_custom,
	)
);

add_ux_builder_shortcode( 'featured_products',
	array(
		'name'      => 'محصولات - ویژه',
		'category'  => __( 'Shop', 'flatsome' ),
		'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
		'wrap'      => false,
		'options'   => $options,
	)
);

add_ux_builder_shortcode( 'recent_products',
	array(
		'name'      => 'محصولات - اخیر',
		'category'  => __( 'Shop', 'flatsome' ),
		'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
		'wrap'      => false,
		'options'   => $options,
	)
);

add_ux_builder_shortcode( 'sale_products',
	array(
		'name'      => 'محصولات - در جشنواره فروش',
		'category'  => __( 'Shop', 'flatsome' ),
		'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
		'wrap'      => false,
		'options'   => $options,
	)
);

add_ux_builder_shortcode( 'best_selling_products',
	array(
		'name'      => 'محصولات - پرفروشترین',
		'category'  => __( 'Shop', 'flatsome' ),
		'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
		'wrap'      => false,
		'options'   => $options,
	)
);

add_ux_builder_shortcode( 'top_rated_products',
	array(
		'name'      => 'محصولات - بیشترین نرخ فروش',
		'category'  => __( 'Shop', 'flatsome' ),
		'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_products' ),
		'wrap'      => false,
		'options'   => $options,
	)
);
