<?php

add_ux_builder_shortcode( 'ux_slider', array(
    'type' => 'container',
    'name' => __( 'اسلایدر', 'flatsome' ),
    'category' => __( 'Layout', 'flatsome' ),
    'message' => __( 'اسلایدها را در اینجا اضافه کنید', 'flatsome' ),
    'directives' => array( 'ux-slider' ),
    'allow' => array( 'ux_banner','ux_image','ux_lottie','section','row','ux_banner_grid','logo'),
    'template' => flatsome_ux_builder_template( 'ux_slider.html' ),
    'thumbnail' =>  flatsome_ux_builder_thumbnail( 'slider' ),
    'tools' => 'shortcodes/ux_slider/ux-slider-tools.directive.html',
    'wrap'   => false,
    'info' => '{{ label }}',
    'priority' => -1,

    'toolbar' => array(
        'show_children_selector' => true,
        'show_on_child_active' => true,
    ),

    'children' => array(
        'inline' => true,
        'addable_spots' => array( 'left', 'right' )
    ),

    /*
    'presets' => array(
        array(
            'name' => __( 'Default', 'flatsome' ),
            'content' => '[ux_slider]',
        ),
        array(
            'name' => __( 'Simple Banner', 'flatsome' ),
            'content' => '[ux_slider][ux_banner][/ux_slider]',
        ),
    ), */

    'options' => array(
        'label' => array(
            'type' => 'textfield',
            'heading' => 'برچسب ادمین',
            'placeholder' => 'برچسب ادمین را وارد نمایید...'
        ),
        'type' => array(
          'type' => 'select',
          'heading' => 'نوع',
          'default' => 'slide',
          'options' => array(
            'slide' => 'Slide',
            'fade' => 'Fade',
          ),
        ),
        'layout_options' => array(
          'type' => 'group',
          'heading' => __( 'چیدمان', 'flatsome' ),
          'options' => array(
            'style' => array(
              'type' => 'select',
              'heading' => 'استایل',
              'default' => 'normal',
              'options' => array(
                  'normal' => 'Default',
                  'container' => 'Container',
                  'focus' => 'Focus',
                  'shadow' => 'Shadow',
              ),
              'conditions' => 'type !== "fade"',
            ),
            'slide_width' => array(
              'type' => 'scrubfield',
              'responsive' => true,
              'heading' => 'عرض اسلاید',
              'placeholder' => 'Width in Px',
              'default' => '',
              'min' => '0',
              'conditions' => 'type !== "fade"',
            ),

            'slide_align' => array(
              'type' => 'select',
              'heading' => 'موقعیت اسلاید',
              'default' => 'center',
              'options' => array(
                  'center' => 'Center',
                  'left' => 'Left',
                  'right' => 'Right',
              ),
              'conditions' => 'type !== "fade"',
            ),
            'bg_color' => array(
              'type' => 'colorpicker',
              'heading' => __( 'رنگ پس‌زمینه', 'flatsome' ),
              'format' => 'rgb',
              'position' => 'bottom right',
              'helpers' => require( __DIR__ . '/helpers/colors.php' ),
            ),
            'margin' => array(
              'type' => 'scrubfield',
              'responsive' => true,
              'heading' => __( 'فاصله', 'flatsome' ),
              'default' => '0px',
              'min' => 0,
              'max' => 100,
              'step' => 1
            ),
            'infinitive' => array(
                'type' => 'radio-buttons',
                'heading' => __( 'مصدر', 'flatsome' ),
                'default' => 'true',
                'options' => array(
                    'false'  => array( 'title' => 'خاموش'),
                    'true'  => array( 'title' => 'روشن'),
                ),
            ),
            'freescroll' => array(
                'type' => 'radio-buttons',
                'heading' => __( 'اسکرول آزاد', 'flatsome' ),
                'default' => 'false',
                'options' => array(
                    'false'  => array( 'title' => 'خاموش'),
                    'true'  => array( 'title' => 'روشن'),
                ),
            ),
            'draggable' => array(
                'type' => 'radio-buttons',
                'heading' => __( 'دراگبل', 'flatsome' ),
                'default' => 'true',
                'options' => array(
                    'false'  => array( 'title' => 'خاموش'),
                    'true'  => array( 'title' => 'روشن'),
                ),
            ),
            'parallax' => array(
                'type' => 'slider',
                'heading' => 'پارالکس',
                'unit' => '+',
                'default' => 0,
                'max' => 10,
                'min' => 0,
            ),
            'mobile' => array(
                'type' => 'radio-buttons',
                'heading' => __( 'نمایش برای موبایل', 'flatsome' ),
                'default' => 'true',
                'options' => array(
                    'false'  => array( 'title' => 'خاموش'),
                    'true'  => array( 'title' => 'روشن'),
                ),
            ),
          ),
        ),

        'nav_options' => array(
          'type' => 'group',
          'heading' => __( 'نویگیشن', 'flatsome' ),
          'options' => array(
            'hide_nav' => array(
                'type' => 'radio-buttons',
                'heading' => __( 'همیشه قابل مشاهده', 'flatsome' ),
                'default' => '',
                'options' => array(
                    ''  => array( 'title' => 'خاموش'),
                    'true'  => array( 'title' => 'روشن'),
                ),
            ),
            'nav_pos' => array(
              'type' => 'select',
              'heading' => 'موقعیت',
              'default' => '',
              'options' => array(
                  '' => 'داخل',
                  'outside' => 'بیرون',
              )
            ),
           'nav_size' => array(
              'type' => 'select',
              'heading' => 'سایز',
              'default' => 'بزرگ',
              'options' => array(
                  'large' => 'بزرگ',
                  'normal' => 'متوسط',
              )
            ),
            'arrows' => array(
              'type' => 'radio-buttons',
              'heading' => __( 'نشانگر', 'flatsome' ),
              'default' => 'true',
              'options' => array(
                'false'  => array( 'title' => 'خاموش'),
                'true'  => array( 'title' => 'روشن'),
                ),
            ),
            'nav_style' => array(
              'type' => 'select',
              'heading' => __( 'استایل نشانگر', 'flatsome' ),
              'default' => 'circle',
              'options' => array(
                  'circle' => 'دایره ای',
                  'simple' => 'ساده',
                  'reveal' => 'آشکار',
              )
            ),
            'nav_color' => array(
                'type' => 'radio-buttons',
                'heading' => __( 'رنگ نشانگر', 'flatsome' ),
                'default' => 'light',
                'options' => array(
                    'dark'  => array( 'title' => 'تاریک'),
                    'light'  => array( 'title' => 'روشن'),
                ),
            ),

            'bullets' => array(
              'type' => 'radio-buttons',
              'heading' => __( 'بالت', 'flatsome' ),
              'default' => 'true',
              'options' => array(
                  'false'  => array( 'title' => 'خاموش'),
                  'true'  => array( 'title' => 'روشن'),
              ),
            ),
            'bullet_style' => array(
              'type' => 'select',
              'heading' => 'استایل بالت',
              'default' => 'circle',
              'options' => array(
                'circle' => 'دایره ای',
                'dashes' => 'خط تیره',
                'dashes-spaced' => 'دش ها (فاصله)',
                'simple' => 'ساده',
                'square' => 'مربع',
            )
           ),
          ),
        ),
        'slide_options' => array(
          'type' => 'group',
          'heading' => __( 'اسلاید اتوماتیک', 'flatsome' ),
          'options' => array(
            'auto_slide' => array(
                'type' => 'radio-buttons',
                'heading' => __( 'اسلاید اتوماتیک', 'flatsome' ),
                'default' => 'true',
                'options' => array(
                    'false'  => array( 'title' => 'خاموش'),
                    'true'  => array( 'title' => 'روشن'),
                ),
            ),
            'timer' => array(
                'type' => 'textfield',
                'heading' => 'تایمر (میلی ثانیه)',
                'default' => 6000,
            ),
            'pause_hover' => array(
                'type' => 'radio-buttons',
                'heading' => __( 'مکث در حالت هاور', 'flatsome' ),
                'default' => 'true',
                'options' => array(
                    'false'  => array( 'title' => 'خاموش'),
                    'true'  => array( 'title' => 'روشن'),
                ),
            ),
          ),
        ),
        'advanced_options' => require( __DIR__ . '/commons/advanced.php'),
    ),
) );
