<?php

// Shortcode to display a single product
$options = array(
'post_options' => require( __DIR__ . '/commons/repeater-posts.php' ),
'filter_posts' => array(
    'type' => 'group',
    'heading' => __( 'فیلترگذاری مطالب', 'flatsome' ),
    'conditions' => 'ids == ""',
    'options' => array(
         'orderby' => array(
            'type' => 'select',
            'heading' => __( 'فیلتر بر اساس', 'flatsome' ),
            'default' => 'normal',
            'options' => array(
                'normal' => 'Normal',
                'title' => 'Title',
                'sales' => 'Sales',
				'price' => 'Price',
                'rand' => 'Random',
                'date' => 'Date'
            )
        ),
        'order' => array(
            'type' => 'select',
            'heading' => __( 'مرتب‌سازی', 'flatsome' ),
            'default' => 'desc',
            'options' => array(
                'asc' => 'صعودی',
                'desc' => 'نزولی',
            )
        ),
        'show' => array(
            'type' => 'select',
            'heading' => __( 'نمایش', 'flatsome' ),
            'default' => '',
            'options' => array(
                '' => 'همه',
                'featured' => 'ویژه',
                'onsale' => 'درحال فروش',
            )
        ),
         'out_of_stock' => array(
	         'type'    => 'select',
	         'heading' => __( 'ناموجود', 'flatsome' ),
	         'default' => '',
	         'options' => array(
		         ''        => 'شامل',
		         'exclude' => 'مستثنی شده',
	         ),
         ),
    )
)
);

$options['post_options']['options']['tags'] = array(
  'type' => 'select',
  'heading' => 'برچسب',
  'conditions' => 'ids == ""',
  'full_width' => true,
  'default' => '',
  'config' => array(
	  'multiple' => true,
      'placeholder' => 'Select...',
      'termSelect' => array(
          'post_type' => 'product',
          'taxonomies' => 'product_tag',
      ),
  )
);

add_ux_builder_shortcode( 'ux_products_list', array(
    'name' => 'لیست محصولات',
    'category' => __( 'Shop', 'flatsome' ),
    'priority' => 2,
    'thumbnail' =>  flatsome_ux_builder_thumbnail( 'products-list' ),
    'presets' => array(
            array(
                'name' => __( 'پیشفرض', 'flatsome' ),
                'content' => '[ux_products_list]'
            ),
            array(
                'name' => __( 'جشنواره فروش', 'flatsome' ),
                'content' => '[ux_products_list orderby="sales" show="onsale"]'
            ),
            array(
                'name' => __( 'محصولات ویژه', 'flatsome' ),
                'content' => '[ux_products_list show="featured"]'
            ),
             array(
                'name' => __( 'بیشترین فروش', 'flatsome' ),
                'content' => '[ux_products_list orderby="sales"]'
      ),
    ),
    'options' => $options
) );
