<?php
/**
 * Registers the Lottie animation element in UX Builder.
 *
 * @package Flatsome
 */

add_ux_builder_shortcode( 'ux_lottie', array(
	'name'      => __( 'متحرک - سه بعدی', 'flatsome' ),
	'category'  => __( 'Content', 'flatsome' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'ux_lottie' ),
	'template'  => flatsome_ux_builder_template( 'ux_lottie.html' ),
	'wrap'      => false,
	'options'   => array(
		'path'             => array(
			'type'        => 'file',
			'heading'     => __( 'نوع انیمیشن را انتخاب کنید', 'flatsome' ),
			'placeholder' => __( 'فایل را انتخاب نمایید یا نشانی اینترنتی را بگذارید', 'flatsome' ),
			'full_width'  => true,
			'mime_types'  => array( 'application/json', 'text/plain' ),
			'default'     => '',
		),
		'settings_options' => array(
			'type'    => 'group',
			'heading' => __( 'تنظیمات', 'flatsome' ),
			'options' => array(
				'loop'               => array(
					'type'    => 'checkbox',
					'heading' => __( 'حلقه - تکرار', 'flatsome' ),
					'default' => 'true',
				),
				'autoplay'           => array(
					'type'    => 'checkbox',
					'heading' => __( 'پخش خودکار', 'flatsome' ),
					'default' => 'true',
				),
				'trigger'            => array(
					'type'       => 'select',
					'heading'    => __( 'تریگر', 'flatsome' ),
					'conditions' => 'autoplay != "true"',
					'default'    => '',
					'options'    => array(
						''       => 'None (static)',
						'hover'  => 'On hover',
						'click'  => 'On click',
						'scroll' => 'On scroll',
					),
				),
				'mouseout'           => array(
					'type'       => 'select',
					'heading'    => __( 'ماوس بیرون', 'flatsome' ),
					'conditions' => 'autoplay != "true" && trigger == "hover"',
					'default'    => '',
					'options'    => array(
						''        => 'Pause',
						'reverse' => 'Reverse',
					),
				),
				'speed'              => array(
					'type'       => 'slider',
					'heading'    => __( 'سرعت', 'flatsome' ),
					'conditions' => 'autoplay == "true" || trigger == "hover" || trigger == "click"',
					'default'    => '1',
					'min'        => '0',
					'max'        => '5',
					'step'       => '0.1',
				),
				'reverse'            => array(
					'type'       => 'checkbox',
					'heading'    => __( 'برعکس', 'flatsome' ),
					'conditions' => 'autoplay == "true" || trigger == "hover" || trigger == "click"',
					'default'    => 'false',
				),
				'scroll_action_type' => array(
					'type'       => 'radio-buttons',
					'heading'    => __( 'نوع اکشن اسکرول', 'flatsome' ),
					'full_width' => true,
					'conditions' => 'autoplay != "true" && trigger == "scroll"',
					'default'    => 'seek',
					'options'    => array(
						'seek'     => array( 'title' => 'سیک' ),
						'play'     => array( 'title' => 'پخش' ),
						'playOnce' => array( 'title' => 'فقط یکبار پخش' ),
					),
				),
				'visibility_start'   => array(
					'type'        => 'slider',
					'heading'     => __( 'شروع دید', 'flatsome' ),
					'full_width'  => true,
					'description' => 'در رابطه با ویوپرت شروع کنید',
					'conditions'  => 'autoplay != "true" && trigger == "scroll"',
					'default'     => '0',
					'min'         => '0',
					'max'         => '100',
					'step'        => '1',
					'unit'        => '%',
				),
				'visibility_end'     => array(
					'type'        => 'slider',
					'heading'     => __( 'پایان دید', 'flatsome' ),
					'full_width'  => true,
					'description' => 'در رابطه با نمای دید تمام کنید',
					'conditions'  => 'autoplay != "true" && trigger == "scroll"',
					'default'     => '100',
					'min'         => '0',
					'max'         => '100',
					'step'        => '1',
					'unit'        => '%',
				),
				'start'              => array(
					'type'       => 'slider',
					'heading'    => __( 'شروع فریم', 'flatsome' ),
					'full_width' => true,
					'default'    => '0',
					'min'        => '0',
					'max'        => '100',
					'step'       => '1',
					'unit'       => '%',
				),
				'end'                => array(
					'type'       => 'slider',
					'heading'    => __( 'پایان فریم', 'flatsome' ),
					'full_width' => true,
					'default'    => '100',
					'min'        => '0',
					'max'        => '100',
					'step'       => '1',
					'unit'       => '%',
				),
				'controls'           => array(
					'type'    => 'checkbox',
					'heading' => __( 'کنترل‌ها', 'flatsome' ),
					'default' => 'false',
				),
			),
		),
		'layout_options'   => array(
			'type'    => 'group',
			'heading' => __( 'چیدمان', 'flatsome' ),
			'options' => array(
				'width'   => array(
					'type'       => 'scrubfield',
					'heading'    => __( 'عرض', 'flatsome' ),
					'responsive' => true,
					'default'    => '100%',
					'min'        => '0',
				),
				'height'  => array(
					'type'       => 'scrubfield',
					'heading'    => __( 'ارتفاع', 'flatsome' ),
					'responsive' => true,
					'default'    => '300px',
					'min'        => '0',
				),
				'padding' => array(
					'type'       => 'margins',
					'heading'    => __( 'فاصله‌داخلی', 'flatsome' ),
					'full_width' => true,
					'responsive' => true,
					'min'        => 0,
					'step'       => 1,
				),
				'margin'  => array(
					'type'       => 'margins',
					'heading'    => __( 'فاصله خارجی - مارجین', 'flatsome' ),
					'full_width' => true,
					'responsive' => true,
					'step'       => 1,
				),
			),
		),
		'link_options'     => require __DIR__ . '/commons/links.php',
		'advanced_options' => require __DIR__ . '/commons/advanced.php',
	),
) );
