<?php

$facebook_accounts = flatsome_facebook_accounts();
$default_account   = ! empty( $facebook_accounts )
	? array_keys( $facebook_accounts )[0]
	: '';

$options = array(
'pages_options' => array(
    'type' => 'group',
    'heading' => __( 'ویژگی ها', 'flatsome' ),
    'options' => array(

    'username' => array(
      'type' => 'select',
      'heading' => 'اکانت',
      'default' => '',
      'options' => array_merge(
        array( '' => '-' ),
        wp_list_pluck( $facebook_accounts, 'username', 'username' )
      ),
    ),

	'loading' => array(
		'type' => 'select',
		'heading' => __( 'در حال بارگذاری', 'flatsome' ),
		'default' => '',
		'options' => array(
		  ''     => __( 'پیشفرض', 'flatsome' ),
		  'lazy' => __( 'لیزی', 'flatsome' ),
		),
	),

    'photos' => array(
        'type' => 'slider',
        'heading' => 'تصاویر',
        'default' => 10,
        'max' => 12,
        'min' => 3,
    ),

    'caption' => array(
          'type' => 'radio-buttons',
          'heading' => __( 'کپشن ها', 'flatsome' ),
          'default' => 'true',
          'options' => array(
              0  => array( 'title' => 'خاموش'),
              'true'  => array( 'title' => 'روشن'),
          ),
    ),

    'image_overlay' => array(
        'type'      => 'colorpicker',
        'heading'   => __( 'آورلای تصاویر', 'flatsome' ),
        'default'   => '',
        'alpha'     => true,
        'format'    => 'rgb',
        'position'  => 'bottom right',
        'on_change' => array(
          'selector' => '.overlay',
          'style'    => 'background-color: {{ value }}',
        ),
    ),

    'image_hover' => array(
        'type' => 'select',
        'heading' => __( 'شناور', 'flatsome' ),
        'default' => '',
        'options' => require( __DIR__ . '/values/image-hover.php' ),
        'on_change' => array(
            'selector' => '.instagram-image-container',
            'class' => 'image-{{ value }}'
        )
    ),
  ),
),
'layout_options' => require( __DIR__ . '/commons/repeater-options.php' ),
'layout_options_slider' => require( __DIR__ . '/commons/repeater-slider.php' ),
'advanced_options' => require( __DIR__ . '/commons/advanced.php'),
'hashtag_options' => array(
    'type' => 'group',
    'heading' => __( 'هشتگ', 'flatsome' ),
    'description' => 'این گزینه‌ها منسوخ شده‌اند و در به‌روزرسانی بعدی حذف خواهند شد.',
    'options' => array(
      'hashtag' => array(
        'type'    => 'textfield',
        'heading' => 'هشتگ',
        'default' => ''
      ),
      'hashtag_media' => array(
        'type'    => 'select',
        'heading' => __( 'نوع هشتگ مدیا', 'flatsome' ),
        'default' => 'top',
        'conditions' => 'hashtag !== ""',
        'options' => array(
          'top'    => 'Top media',
          'recent' => 'رسانه های اخیر (در عرض 24 ساعت)'
        ),
      ),
    ),
),
);

// Set defaults.
$options['layout_options']['options']['columns']['default']     = '5';
$options['layout_options']['options']['col_spacing']['default'] = 'collapse';
$options['layout_options']['options']['type']['default']        = 'row';
$options['layout_options']['options']['type']['options']        = array(
  'slider' => 'Slider',
  'row'    => 'Row',
);

add_ux_builder_shortcode( 'ux_instagram_feed', array(
  'name'      => __( 'فید اینستاگرام', 'flatsome' ),
  'category'  => __( 'Content', 'flatsome' ),
  'thumbnail' => flatsome_ux_builder_thumbnail( 'instagram_feed' ),
  'presets'   => array(
    array(
      'name'    => __( 'Default', 'flatsome' ),
      'content' => '[ux_instagram_feed username="' . $default_account . '"]',
    ),
    array(
      'name'    => __( 'گرید ساده', 'flatsome' ),
      'content' => '[ux_instagram_feed username="' . $default_account . '" col_spacing="small"]',
    ),
    array(
      'name'    => __( 'اسلایدر تمام عرض', 'flatsome' ),
      'content' => '[ux_instagram_feed username="' . $default_account . '" type="slider" slider_nav_color="light" width="full-width" columns="6"]',
    ),
    array(
      'name'    => __( 'اسلایدر ساده', 'flatsome' ),
      'content' => '[ux_instagram_feed username="' . $default_account . '" type="slider" slider_nav_position="outside" col_spacing="small"]',
    ),
    array(
      'name'    => __( 'تمام عرض', 'flatsome' ),
      'content' => '[ux_instagram_feed username="' . $default_account . '" image_hover="color" type="slider" slider_nav_color="light" width="full-width" columns="6"]',
    ),
  ),
  'options'   => $options,
) );
