<?php

$position_options = require( __DIR__ . '/commons/position.php' );
$position_options['options']['position_x']['on_change'] = array(
  'recompile' => false,
  'class' => 'x{{ value }} md-x{{ value }} lg-x{{ value }}'
);
$position_options['options']['position_y']['on_change'] = array(
  'recompile' => false,
  'class' => 'y{{ value }} md-y{{ value }} lg-y{{ value }}'
);

add_ux_builder_shortcode( 'ux_hotspot', array(
  'name' => 'هات اسپات',
  'category' => __( 'Content', 'flatsome' ),
  'require' => 'ux_banner',
  'thumbnail' =>  flatsome_ux_builder_thumbnail( 'ux_hotspot' ),
  //'template' => flatsome_ux_builder_template( 'ux_hotspot.html' ),
  'allow_in' => array('ux_banner'),
  'wrap' => false,
  'options' => array(
       'type' => array(
            'type' => 'radio-buttons',
            'heading' => 'نوع',
            'default' => 'text',
            'options' => array(
                'text'   => array( 'title' => 'متن'),
                'product'  => array( 'title' => 'Product'),
            ),
        ),
        'prod_id' => array(
          'type' => 'select',
          'heading' => __( 'محصول', 'flatsome' ),
          'full-width' => true,
          'conditions' => 'type === "product"',
          'config' => array(
              'multiple' => false,
              'placeholder' => 'Select..',
              'postSelect' => array(
                  'post_type' => array( 'product')
              ),
          )
        ),

        'text' => array(
          'type' => 'textfield',
          'holder' => 'button',
          'heading' => __( 'متن', 'flatsome' ),
          'conditions' => 'type === "text"',
          'param_name' => 'text',
          'focus' => 'true',
          'default' => 'هر متنی وارد نمایید...',
        ),
        'link' => array(
          'type' => 'textfield',
          'holder' => 'button',
          'heading' => __( 'لینک', 'flatsome' ),
          'conditions' => 'type === "text"',
          'param_name' => 'text',
          'focus' => 'true',
          'default' => '',
       ),
       'icon' => array(
            'type' => 'radio-buttons',
            'heading' => __( 'آیکون', 'flatsome' ),
            'default' => 'plus',
            'options' => array(
                'plus'  => array( 'title' => 'پلاس'),
                'search'   => array( 'title' => 'جستجو'),
                'play'  => array( 'title' => 'پلی'),
            ),
      ),
      'size' => array(
          'type' => 'radio-buttons',
          'heading' => __( 'سایز', 'flatsome' ),
          'default' => 'medium',
          'options' => array(
              'xsmall'   => array( 'title' => 'XS'),
              'small'   => array( 'title' => 'S'),
              'medium'  => array( 'title' => 'M'),
              'large'  => array( 'title' => 'L'),
              'xlarge'  => array( 'title' => 'XL'),
          ),
      ),
      'bg_color' => array(
          'type' => 'colorpicker',
          'heading' => __( 'رنگ پس‌زمینه', 'flatsome' ),
          'format' => 'rgb',
          'position' => 'bottom right',
          'helpers' => require( __DIR__ . '/helpers/colors.php' ),
      ),
      'animate' => array(
              'type' => 'select',
              'heading' => __( 'انیمیشن', 'flatsome' ),
              'param_name' => 'animate',
              'default' => 'none',
              'options' => require( __DIR__ . '/values/animate.php' ),
      ),
      'depth' => array(
              'type' => 'slider',
              'heading' => __( 'عمق', 'flatsome' ),
              'default' => '0',
              'max' => '5',
              'min' => '0',
      ),
      'depth_hover' => array(
              'type' => 'slider',
              'heading' => __( 'دیپ هاور', 'flatsome' ),
              'default' => '0',
              'max' => '5',
              'min' => '0',
      ),
      'position_options' => $position_options,
      'advanced_options' => require( __DIR__ . '/commons/advanced.php'),

  )
) );
