<?php

// Add to builder
add_ux_builder_shortcode( 'ux_countdown', array(
    'name' => __( 'Countdown', 'flatsome' ),
    'category' => __( 'Content', 'flatsome' ),
    'thumbnail' =>  flatsome_ux_builder_thumbnail( 'countdown' ),
    'allow_in' => array('text_box'),
    'scripts' => array(
        'flatsome-countdown-script' => get_template_directory_uri() . '/inc/shortcodes/ux_countdown/countdown-script-min.js',
        'flatsome-countdown-theme-js' => get_template_directory_uri() . '/inc/shortcodes/ux_countdown/ux-countdown.js'
    ),
    'styles' => array(
        'flatsome-countdown-style' => get_template_directory_uri() . '/inc/shortcodes/ux_countdown/ux-countdown.css',
    ),
    'options' => array(
        'style' => array(
            "type" => "select",
            "heading" => __( 'Style', 'flatsome' ),
            "default" => 'clock',
            "options" => array(
              'clock' => 'Clock',
              'text' => 'متن',
            )
        ),
	   'size' => array(
            'type' => 'slider',
            'heading' => __( 'سایز', 'flatsome' ),
            'responsive' => true,
            'default' => '300',
            'unit' => '%',
            'responsive' => true,
            'max' => '400',
            'min' => '0',
            'on_change' => array(
                'selector' => '.ux-timer, .ux-timer-text',
                'style' => 'font-size: {{ value }}%'
            ),
        ),
        'color' => array(
                'type' => 'radio-buttons',
                'heading' => __( 'رنگ', 'flatsome' ),
                'default' => 'dark',
                'options' => array(
                    'dark' => array( 'title' => 'روشن' ),
                    'light' => array( 'title' => 'تاریک' ),
                ),
        ),
        'bg_color' => array(
          'type' => 'colorpicker',
          'heading' => __( 'پس زمینه', 'flatsome' ),
          'responsive' => true,
          'default' => '',
          'alpha' => true,
          'format' => 'rgb',
          'position' => 'پایین راست',
          'helpers' => require( __DIR__ . '/helpers/colors.php' ),
        ),
        'year' => array(
            "type" => "textfield",
            "heading" => "Year",
            "default" => "2021"
        ),
        'month' => array(
            "type" => "textfield",
            "heading" => "ماه",
            "default" => "12"
        ),
        'day' => array(
            "type" => "textfield",
            "heading" => "روز",
            "default" => "31"
        ),
        'time' => array(
            "type" => "textfield",
            "heading" => "زمان",
            "default" => "18:00"
        ),
        'translations' => array(
            'type' => 'group',
            'heading' => 'متن ها',
            'options' => array(
                't_week' => array( "type" => "textfield", "heading" => "Week", "default" => "week"),
                't_day' => array( "type" => "textfield", "heading" => "Day", "default" => "day"),
                't_hour' => array( "type" => "textfield", "heading" => "Hour", "default" => "hour"),
                't_min' => array( "type" => "textfield", "heading" => "Min", "default" => "min"),
                't_sec' => array( "type" => "textfield", "heading" => "Sec", "default" => "sec"),
            )
        ),
        'translations_p' => array(
            'type' => 'group',
            'heading' => 'جمع متن‌ها',
            'options' => array(
                't_plural' => array( "type" => "textfield", "heading" => "Plural default", "default" => ""),
                't_week_p' => array( "type" => "textfield", "heading" => "Week Plural"),
                't_day_p' => array( "type" => "textfield", "heading" => "Day Plural"),
                't_hour_p' => array( "type" => "textfield", "heading" => "Hour Plural"),
                't_min_p' => array( "type" => "textfield", "heading" => "Min Plural"),
                't_sec_p' => array( "type" => "textfield", "heading" => "Sec Plural"),
            )
        )
     )
) );
