<?php

add_ux_builder_shortcode( 'row', array(
    'type' => 'container',
    'name' => __( 'ردیف' , 'ux-builder' ),
    'image' => '',
    'category' => __( 'Layout', 'flatsome' ),
    'template' => flatsome_ux_builder_template( 'row.html' ),
    'thumbnail' =>  flatsome_ux_builder_thumbnail( 'row' ),
    'tools' => 'shortcodes/row-tools.directive.html',
    'info' => '{{ label }}',
    'allow' => array( 'col' ),
    'nested' => true,
    'wrap'   => false,
    'priority' => -1,

    'presets' => array(
        array(
            'name' => __( '3 ستون', 'flatsome' ),
            'content' => '[row][col span="4" span__sm="12"][/col][col span="4" span__sm="12"][/col][col span="4" span__sm="12"][/col]][/row]',
            'thumbnail' =>  flatsome_ux_builder_thumbnail( 'row-3-col' ),
        ),
        array(
            'name' => __( '2 ستون', 'flatsome' ),
            'content' => '[row][col span="6" span__sm="12"][/col][col span="6" span__sm="12"][/col][/row]',
            'thumbnail' =>  flatsome_ux_builder_thumbnail( 'row-2-col' ),
        ),
        array(
            'name' => __( '4 ستون', 'flatsome' ),
            'thumbnail' =>  flatsome_ux_builder_thumbnail( 'row-4-col' ),
            'content' => '[row][col span="3" span__sm="6"][/col][col span="3" span__sm="6"][/col][col span="3" span__sm="6"][/col][col span="3" span__sm="6"][/col][/row]'
        ),
        array(
            'name' => __( '1 ستون', 'flatsome' ),
            'content' => '[row][col span="12" span__sm="12"][/col][/row]',
            'thumbnail' =>  flatsome_ux_builder_thumbnail( 'row-1-col' ),
        ),
        array(
            'name' => __( 'راست بزرگ', 'flatsome' ),
            'content' => '[row][col span="4" span__sm="12"][/col][col span="8" span__sm="12"][/col][/row]',
            'thumbnail' =>  flatsome_ux_builder_thumbnail( 'row-1-3-col' ),
        ),
        array(
            'name' => __( 'چپ بزرگ', 'flatsome' ),
            'content' => '[row][col span="8" span__sm="12"][/col][col span="4" span__sm="12"][/col][/row]',
            'thumbnail' =>  flatsome_ux_builder_thumbnail( 'row-2-3-col' ),
        ),
        array(
            'name' => __( '2 Col - Full', 'flatsome' ),
            'content' => '[row style="collapse" width="full-width"][col span="6"][/col][col span="6"][/col][/row]',
            'thumbnail' =>  flatsome_ux_builder_thumbnail( 'row-2-col-full' ),
        ),
        array(
            'name' => __( '3 ستون - تمام', 'flatsome' ),
            'content' => '[row style="collapse" width="full-width"][col span="4"][/col][col span="4"][/col][col span="4"][/col][/row]',
            'thumbnail' =>  flatsome_ux_builder_thumbnail( 'row-3-col-full' ),
        ),
        array(
            'name' => __( 'رسانه چپ', 'flatsome' ),
            'content' => '[row  v_align="middle"][col span="6" span__sm="12"][ux_image][/col][col span="6" span__sm="12"][/col][/row]',
            'thumbnail' =>  flatsome_ux_builder_thumbnail( 'row-image-left' ),
        ),
        array(
            'name' => __( 'رسانه راست', 'flatsome' ),
            'content' => '[row v_align="middle"][col span="6" span__sm="12"][/col][col span="6" span__sm="12"][ux_image][/col][/row]',
            'thumbnail' =>  flatsome_ux_builder_thumbnail( 'row-image-right' ),
        ),
        array(
            'name' => __( 'بزرگ رسانه چپ', 'flatsome' ),
            'content' => '[row v_align="middle" style="collapse" width="full-width"][col span="6" span__sm="12"][ux_image][/col][col max_width="520px" padding="5% 5% 5% 5%" span="6" span__sm="12"][/col][/row]',
            'thumbnail' =>  flatsome_ux_builder_thumbnail( 'row-image-left-large' ),
        ),
        array(
            'name' => __( 'بزرگ رسانه چپبزرگ رسانه راست', 'flatsome' ),
            'content' => '[row v_align="middle" style="collapse" width="full-width"][col max_width="520px" padding="5% 5% 5% 5%" span="6" span__sm="12" width=""][/col][col span="6" span__sm="12"][ux_image][/col][/row]',
            'thumbnail' =>  flatsome_ux_builder_thumbnail( 'row-image-right-large' ),
        ),
        array(
            'name' => __( '3 ستون - رها کردن سایه', 'flatsome' ),
            'content' => '[row depth="3" depth_hover="5"][col span="4" span__sm="12"][/col][col span="4" span__sm="12"][/col][col span="4" span__sm="12"][/col]][/row]',
            'thumbnail' =>  flatsome_ux_builder_thumbnail( 'row-3-shadow-col' ),
        ),
        array(
            'name' => __( '3 ستونه - خط تیره', 'flatsome' ),
            'content' => '[row col_style="dashed"][col span="4" span__sm="12"][/col][col span="4" span__sm="12"][/col][col span="4" span__sm="12"][/col][col span="4" span__sm="12"][/col][col span="4" span__sm="12"][/col][col span="4" span__sm="12"][/col]][/row]',
            'thumbnail' =>  flatsome_ux_builder_thumbnail( 'row-3-col-dashed' ),
        )
    ),

    'options' => array(

        'label' => array(
            'full_width' => true,
            'type' => 'textfield',
            'heading' => 'برچسب',
            'placeholder' => 'برچسب مدیریت را در اینجا وارد کنید..'
        ),

        'style' => array(
            'type' => 'radio-buttons',
            'heading' => 'فاصله ستون',
            'full_width' => true,
            'default' => '',
            'options' => array(
                '' => array( 'title' => 'نرمال'),
                'small' => array( 'title' => 'کوچک' ),
                'large' => array( 'title' => 'بزرک' ),
                'collapse' => array( 'title' => 'کولاپس' ),
            ),
        ),

        'col_style' => array(
            'type' => 'radio-buttons',
            'heading' => 'استایل ستون',
            'full_width' => true,
            'default' => '',
            'options' => array(
                '' => array( 'title' => 'نرمال'),
                'divided' => array( 'title' => 'تقسم شده'),
                'dashed' => array( 'title' => 'خط تیره'),
                'solid' => array( 'title' => 'حاشیه'),
            ),
        ),

        'col_bg' => array(
            'type' => 'colorpicker',
            'heading' => __( 'پس زمینه ستون', 'flatsome' ),
            'format' => 'rgb',
            'alpha' => true,
            'position' => 'پایین راست',
            'helpers' => require( __DIR__ . '/helpers/colors.php' ),
        ),

        'col_bg_radius' => array(
	        'type'       => 'slider',
	        'vertical'   => true,
	        'full_width' => true,
	        'heading'    => __( 'ستون گرد', 'flatsome' ),
	        'unit'       => 'px',
	        'default'    => 0,
	        'min'        => 0,
	        'max'        => 100,
        ),

        'width' => array(
            'type' => 'radio-buttons',
            'heading' => 'عرض',
            'full_width' => true,
            'default' => '',
            'options' => array(
                '' => array( 'title' => 'کانتینر'),
                'full-width' => array( 'title' => 'تمام عرض' ),
                'custom' => array( 'title' => 'سفارشی' ),
            ),
        ),

        'custom_width' => array(
            'type' => 'scrubfield',
            'conditions' => 'width == "custom"',
            'heading' => 'عرض سفارشی',
            'default' => '',
            'placeholder' => '1080px'
        ),

        'v_align' => array(
            'type' => 'radio-buttons',
            'heading' => 'موقعیت عمودی',
            'full_width' => true,
            'default' => '',
            'options' => array(
                '' => array( 'title' => 'بالا'),
                'equal' => array( 'title' => 'برابر'),
                'middle' => array( 'title' => 'وسط'),
                'bottom' => array( 'title' => 'پایین'),
            )
        ),

        'h_align' => array(
            'type' => 'radio-buttons',
            'heading' => 'موقعیت در عرض',
            'full_width' => true,
            'default' => '',
            'options' => array(
                 '' => array( 'title' => 'چپ'),
                 'center' => array( 'title' => 'وسط'),
                 'right' => array( 'title' => 'راست')
            )
        ),

        'padding' => array(
            'type' => 'margins',
            'heading' => 'فاصله ستون',
            'full_width' => true,
            'responsive' => true,
            'min' => 0,
            'max' => 100,
            'step' => 1,
        ),

        'depth' => array(
            'type' => 'slider',
            'vertical' => true,
            'full_width' => true,
            'heading' => 'عمق ستون',
            'default' => 0,
            'max' => 5,
            'min' => 0,
        ),

        'depth_hover' => array(
            'type' => 'slider',
            'vertical' => true,
            'full_width' => true,
            'heading' => 'شناور عمق ستون',
            'default' => 0,
            'max' => 5,
            'min' => 0,
        ),

       'advanced_options' => require( __DIR__ . '/commons/advanced.php'),
    ),
) );
