<?php

add_ux_builder_shortcode( 'ux_price_table', array(
  'type' => 'container',
  'name' => __( 'جدول قیمت گذاری', 'flatsome' ),
  'category' => __( 'Content', 'flatsome' ),
  'thumbnail' => flatsome_ux_builder_thumbnail( 'price_table' ),
  'allow' => array('text','bullet_item','button'),
  'wrap' => false,
  'presets' => array(
    array(
      'name' => __( 'Default', 'flatsome' ),
      'content' => '[ux_price_table title="Title" price="price" featured="false"][bullet_item text="Title"][bullet_item text="Title"][bullet_item text="Title"][bullet_item text="Title"][/ux_price_table]',
      ),
    ),
    'options' => array(
      'title' => array( 'type' => 'textfield','heading' => 'عنوان', 'default' => 'عنوان', 'on_change' => array('selector' => '.title', 'content' => '{{value}}' )),
      'price' => array( 'type' => 'textfield','heading' => 'قیمت', 'default' => '100 تومان ','on_change' => array('selector' => '.price', 'content' => '{{value}}')),
      'description' => array( 'type' => 'textfield','heading' => 'توضیحات.', 'default' => 'توضیحات','on_change' => array('selector' => '.description', 'content' => '{{value}}')),
  
      'featured' => array(
            'type' => 'radio-buttons',
            'heading' => __( 'ویژگی‌ها', 'flatsome' ),
            'default' => 'false',
            'options' => array(
                'false'  => array( 'title' => 'خیر'),
                'true'  => array( 'title' => 'بله'),
            ),
            'on_change' => array(
              'recompile' => false,
              'selector' => '.pricing-table',
              'class' => array(
                'false'  => '',
                'true'  => 'featured-table',
              ),
            ),
      ),
      'color' => array(
            'type' => 'radio-buttons',
            'heading' => __( 'متن رنگ', 'flatsome' ),
            'default' => '',
            'options' => array(
                ''  => array( 'title' => 'تاریک'),
                'dark'  => array( 'title' => 'روشن'),
            ),
            'on_change' => array(
              'recompile' => false,
              'class' => '{{ value }}',
            ),
      ),
      'bg_color' => array(
        'type' => 'colorpicker',
        'heading' => __( 'رنگ‌پس‌زمینه', 'flatsome' ),
        'format' => 'rgb',
        'position' => 'bottom right',
        'on_change' => array(
          'selector' => '.pricing-table',
          'style' => 'background-color: {{value}}',
        ),
      ),
      'radius' => array(
        'type' => 'slider',
        'heading' => __( 'ردیوس', 'flatsome' ),
        'default' => '0',
        'unit' => 'px',
        'max' => '30',
        'min' => '0',
        'on_change' => array(
          'selector' => '.pricing-table',
          'style' => 'border-radius: {{value}}px',
        ),
      ),
     'depth' => array(
        'type' => 'slider',
        'heading' => __( 'دیپ', 'flatsome' ),
        'default' => '0',
        'max' => '5',
        'min' => '0',
        'on_change' => array(
          'recompile' => false,
          'selector' => '.pricing-table',
          'class' => 'box-shadow-{{ value }}'
        ),
      ),
      'depth_hover' => array(
          'type' => 'slider',
          'heading' => __( 'دیپ هاور', 'flatsome' ),
          'default' => '3',
          'max' => '5',
          'min' => '0',
          'on_change' => array(
            'recompile' => false,
            'selector' => '.pricing-table',
            'class' => 'box-shadow-{{ value }}-hover'
          ),
      ),
      'advanced_options' => require( __DIR__ . '/commons/advanced.php'),
    )
) );

add_ux_builder_shortcode( 'bullet_item', array(
    'name' => __( 'Bullet Item', 'flatsome' ),
    'info' => '{{ title }}',
    'require' => array( 'ux_price_table' ),
    'template' => '
      <div class="bullet-item"
        ng-class="{
          \'tooltip\': !!shortcode.options.tooltip,
          \'has-hover\': !!shortcode.options.tooltip,
          \'is-disabled\': shortcode.options.enabled !== \'true\'
        }"
        ng-attr-title="shortcode.options.tooltip">
        <span class="text" ng-bind-html="shortcode.options.text | html"></span>
        <span ng-if="shortcode.options.tooltip" class="tag-label bullet-more-info circle">?</span>
      </div>
    ',
    'wrap' => false,
    'hidden' => true,
    'options' => array(
      'text' => array(
        'type' => 'textfield',
        'heading' => 'متـــن',
        'default' => 'Add any text here',
      ),
      'tooltip' => array(
        'type' => 'textfield',
        'heading' => 'تولتیپ',
        'default' => '',
      ),
      'enabled' => array(
          'type' => 'radio-buttons',
          'heading' => __( 'فعالسازی', 'flatsome' ),
          'default' => 'true',
          'options' => array(
              'true'  => array( 'title' => 'بله'),
              'false'  => array( 'title' => 'خیر'),
          ),
        ),
    ),
) );
