<?php

add_ux_builder_shortcode( 'page_header', array(
  'name' => __( 'برگه هدر', 'flatsome' ),
  'category' => __( 'Layout', 'flatsome' ),
  'wrap' => false,
  'thumbnail' =>  flatsome_ux_builder_thumbnail( 'page_title' ),
  'allow' => array(),
  'presets' => array(),
  'options' => array(
  	 'layout_options' => array(
      'type' => 'group',
      'heading' => __( 'چیدمان', 'flatsome' ),
      'options' => array(
      	'height' => array(
          'type' => 'scrubfield',
          'responsive' => true,
          'heading' => __( 'ارتفاع', 'flatsome' ),
          'default' => '',
          'placeholder' => __( 'پیشفرض', 'flatsome' ),
          'min' => 0,
          'step' => 1,
           'on_change' => array(
              'recompile' => false,
              'selector' => '.page-title-inner',
              'style' => 'min-height: {{ value }}'
          )
        ),

        'margin' => array(
          'type' => 'scrubfield',
          'responsive' => true,
          'heading' => __( 'مارجین - فاصله', 'flatsome' ),
          'min' => 0,
          'step' => 1,
           'on_change' => array(
            'recompile' => false,
            'style' => 'margin-bottom: {{ value }}'
          )
        ),

        'style' => array(
            'type' => 'select',
            'heading' => 'استایل محتوا',
            'full_width' => true,
            'default' => 'featured',
            'options' => array(
            	'featured' => 'ویژه',
            	'normal' => 'فلت',
                'simple' => 'سیمپل',
                'divided' => 'دیواید',
            )
        ),

        'type' => array(
            'type' => 'select',
            'heading' => 'نوع محتوا',
            'full_width' => true,
            'default' => 'breadcrumbs',
            'options' => array(
            	'breadcrumbs' => 'برادکرامپ',
                'subnav' => 'زیر نویگیشن',
                'onpage' => 'اسکرول به نویگیشن',
                'share' => 'اشتراک گذاری آیکون'
            )
        ),

        'text_color' => array(
          'type' => 'radio-buttons',
          'heading' => __( 'رنگ متن', 'flatsome' ),
          'default' => 'light',
          'options' => array(
            'light'  => array( 'title' => 'روشن'),
            'dark'  => array( 'title' => 'تاریک'),
          ),
        ),

        'align' => array(
            'type' => 'radio-buttons',
            'heading' => 'موقعیت',
            'full_width' => true,
            'default' => 'left',
            'options' => array(
            	'left' => array( 'title' => 'چپ'),
              'center' => array( 'title' => 'وسط'),
              'right' => array( 'title' => 'راست'),
            ),
        ),

        'v_align' => array(
            'type' => 'radio-buttons',
            'heading' => 'موقعیت عمودی',
            'full_width' => true,
            'default' => 'center',
            'options' => array(
                'top' => array( 'title' => 'بالا'),
                'center' => array( 'title' => 'وسط'),
                'bottom' => array( 'title' => 'پایین'),
            )
        ),

        'depth' => array(
            'type' => 'slider',
            'vertical' => true,
            'heading' => 'دیپ',
            'default' => 0,
            'max' => 5,
            'min' => 0,
        ),

        'parallax_text' => array(
            'type' => 'slider',
            'heading' => 'محتوا پارالکس',
            'unit' => '+',
            'default' => 0,
            'max' => 10,
            'min' => 0,
        ),
      )
    ),
  	'title_options' => array(
  	   'type' => 'group',
       'heading' => __( 'عنوان', 'flatsome' ),
       'options' => array(

          'show_title' => array(
            'type' => 'checkbox',
            'heading' => 'نمایش عنوان',
            'default' => 'true'
          ),

       	 'title' => array(
            'conditions' => 'show_title',
            'type' => 'textfield',
            'heading' => 'عنوان',
            'placeholder' => __( 'عنوان برگه', 'flatsome' ),
            'default' => '',
       	 ),

       	 'title_size' => array(
            'conditions' => 'show_title',
            'type' => 'select',
            'heading' => 'سایز',
            'options' => require( __DIR__ . '/values/sizes.php' ),
         ),

       	 'title_case' => array(
            'conditions' => 'show_title',
  	        'type' => 'radio-buttons',
  	        'heading' => 'نحوه نمایش متن',
  	        'default' => 'normal',
  	        'options' => array(
              'normal' => array( 'title' => 'Abc' ),
	            'uppercase' => array( 'title' => 'ABC'),
  	        ),
        ),

       	 'sub_title' => array(
            'conditions' => 'show_title',
            'type' => 'textfield',
            'heading' => 'زیر متن',
            'default' => '',
       	 ),
       ),
  	),
  	'nav_options' => array(
      'type' => 'group',
      'heading' => __( 'استایل نویگیشن', 'flatsome' ),
      'options' => array(
      	'nav_style' => array(
            'type' => 'select',
            'heading' => 'استایل',
            'default' => 'line',
            'options' => require( __DIR__ . '/values/nav-styles.php' ),
         ),
      	'nav_size' => array(
            'type' => 'select',
            'heading' => 'سایز',
            'options' => require( __DIR__ . '/values/sizes.php' ),
         ),
      	 'nav_case' => array(
	        'type' => 'radio-buttons',
	        'heading' => 'نحوه نمایش متن',
	        'default' => 'uppercase',
	        'options' => array(
	            'uppercase' => array( 'title' => 'ABC'),
	            'lowercase' => array( 'title' => 'Abc' ),
	        ),
        ),
       )
    ),
  	'background_options' => array(
      'type' => 'group',
      'heading' => __( 'پس زمینه', 'flatsome' ),
      'options' => array(
        'bg' => array(
          'type' => 'image',
          'heading' => __( 'تصویر', 'flatsome' ),
          'thumb_size' => 'bg_size',
          'bg_position' => 'bg_pos',
        ),
        'bg_size'=> array(
          'type' => 'select',
          'heading' => 'سایز',
          'default' => 'large',
          'options' => flatsome_ux_builder_image_sizes()
        ),
        'bg_color' => array(
          'type' => 'colorpicker',
          'heading' => __( 'رنگ', 'flatsome' ),
          'format' => 'rgb',
          'position' => 'bottom right',
          'helpers' => require( __DIR__ . '/helpers/colors.php' ),
        ),
        'bg_overlay' => array(
          'type' => 'colorpicker',
          'heading' => __( 'آورلای', 'flatsome' ),
          'responsive' => true,
          'alpha' => true,
          'format' => 'rgb',
          'position' => 'bottom right',
          'helpers' => require( __DIR__ . '/helpers/colors-overlay.php' ),
        ),
        'bg_pos' => array(
          'type' => 'textfield',
          'heading' => __( 'موقعیت', 'flatsome' ),
           'on_change' => array(
	            'selector' => '.title-bg',
	            'style' => 'background-position: {{ value }}'
          )
        ),
        'parallax' => array(
            'type' => 'slider',
            'heading' => 'پارالکس',
            'unit' => '+',
            'default' => 0,
            'max' => 10,
            'min' => 0,
        ),
    ), // end bgs
  ),
  'advanced_options' => require( __DIR__ . '/commons/advanced.php'),
 ),
) );
