<?php

$sizes = array(
	'xxsmall' => 'XX-Small',
	'xsmall'  => 'X-Small',
	'smaller' => 'Smaller',
	'small'   => 'Small',
	''        => 'Normal',
	'large'   => 'Large',
	'larger'  => 'Larger',
	'xlarge'  => 'X-Large',
	'xxlarge' => 'XX-Large',
);

add_ux_builder_shortcode( 'ux_product_gallery', array(
	'name'      => __( 'گالری محصولات', 'flatsome' ),
	'category'  => __( 'برگه محصولات', 'flatsome' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_gallery' ),
	'overlay'   => true,
	'wrap'      => true,
	'priority'  => 9999,
	'options'   => array(
		'style'                 => array(
			'type'    => 'select',
			'heading' => 'استایل',
			'default' => 'normal',
			'options' => array(
				'normal'     => __( 'نرمال', 'flatsome-admin' ),
				'vertical'   => __( 'عمودی', 'flatsome-admin' ),
				'full-width' => __( 'تمام عرض', 'flatsome-admin' ),
				'stacked'    => __( 'استک شده', 'flatsome-admin' ),
			),
		),
		'grid_layout' => array(
			'type'       => 'select',
			'heading'    => 'گرید لایوت',
			'full_width' => true,
			'conditions' => 'style == "stacked"',
			'default'    => '',
			'options' => array(
				''      => __( '1 ستون', 'flatsome-admin' ),
				'2'     => __( 'ستون', 'flatsome-admin' ),
				'1-2'   => __( 'ویژگی - 2 ستون', 'flatsome-admin' ),
				'3-1-2' => __( '3 ستون - ویژگی - 2 ستون', 'flatsome-admin' ),
			),
		),
		'slider_type' => array(
			'type'       => 'radio-buttons',
			'heading'    => 'نوع اسلایدر',
			'full_width' => true,
			'conditions' => 'style == "normal" || style == "vertical" || style == "stacked"',
			'default'    => '',
			'options'    => array(
				''     => array( 'title' => esc_html__( 'اسلاید', 'flatsome-admin' ) ),
				'fade' => array( 'title' => esc_html__( 'فید', 'flatsome-admin' ) ),
			),
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_title', array(
	'name'      => __( 'عنوان محصول', 'flatsome' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_title' ),
	'category'  => __( 'برگه محصول', 'flatsome' ),
	'options'   => array(
		'size'      => array(
			'type'    => 'select',
			'heading' => 'سایز',
			'default' => '',
			'options' => $sizes,
		),
		'divider'   => array(
			'type'    => 'checkbox',
			'heading' => 'فاصله دهنده',
			'default' => 'true',
		),
		'uppercase' => array(
			'type'    => 'checkbox',
			'heading' => 'نوع نوشتار متن',
			'default' => 'false',
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_rating', array(
	'name'      => __( 'امتیاز محصول', 'flatsome' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_rating' ),
	'wrap'      => true,
	'category'  => __( 'برگه محصول', 'flatsome' ),
	'options'   => array(
		'count'      => array(
			'type'    => 'checkbox',
			'heading' => 'تعداد نقد و بررسی',
			'default' => 'false',
		),
		'style'      => array(
			'type'    => 'select',
			'heading' => 'استایل تعداد نقد و بررسی',
			'default' => 'inline',
			'options' => array(
				'tooltip' => __( 'تولتیپ', 'flatsome-admin' ),
				'stacked' => __( 'استکید', 'flatsome-admin' ),
				'inline'  => __( 'خطی', 'flatsome-admin' ),
			),
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_price', array(
	'name'      => __( 'قیمت محصول', 'flatsome' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_price' ),
	'wrap'      => false,
	'category'  => __( 'برگه محصول', 'flatsome' ),
	'options'   => array(
		'size' => array(
			'type'    => 'select',
			'heading' => 'سایز',
			'default' => '',
			'options' => $sizes,
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_excerpt', array(
	'name'      => __( 'توضیحات کوتاه محصول', 'flatsome' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_short_desc' ),
	'wrap'      => false,
	'category'  => __( 'برگه محصول', 'flatsome' ),
) );

add_ux_builder_shortcode( 'ux_product_add_to_cart', array(
	'name'      => __( 'افزودن محصول به سبد خرید', 'flatsome' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_add_to_cart' ),
	'category'  => __( 'برگه محصول', 'flatsome' ),
	'options'   => array(
		'style' => array(
			'type'    => 'select',
			'heading' => 'فرم استایل',
			'default' => 'normal',
			'options' => array(
				'normal' => __( 'نرم', 'flatsome-admin' ),
				'flat'   => __( 'فلت', 'flatsome-admin' ),
				'minimal'   => __( 'مینیمال', 'flatsome-admin' ),
			),
		),
		'size'  => array(
			'type'    => 'select',
			'heading' => 'سایز',
			'default' => '',
			'options' => $sizes,
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_meta', array(
	'name'      => __( 'محصول متا', 'flatsome' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_meta' ),
	'category'  => __( 'برگه محصول', 'flatsome' ),
) );

add_ux_builder_shortcode( 'ux_product_upsell', array(
	'name'      => __( 'محصولات آپ سل', 'flatsome' ),
	'category'  => __( 'برگه محصول', 'flatsome' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_upsells' ),
	'options'   => array(
		'style' => array(
			'type'    => 'select',
			'heading' => 'استایل',
			'default' => 'sidebar',
			'options' => array(
				'sidebar' => __( 'لیست', 'flatsome-admin' ),
				'grid'    => __( 'گرید', 'flatsome-admin' ),
			),
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_tabs', array(
	'name'      => __( 'تب های محصول', 'flatsome' ),
	'category'  => __( 'برگه محصول', 'flatsome' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_tabs' ),
	'options'   => array(
		'style' => array(
			'type'    => 'select',
			'heading' => 'استایل',
			'default' => 'tabs',
			'options' => array(
				'tabs'          => __( 'تب های خطی', 'flatsome-admin' ),
				'tabs_normal'         => __( 'تب های نرمال', 'flatsome-admin' ),
				'line-grow'           => __( 'تب های خطی گراو', 'flatsome-admin' ),
				'tabs_vertical'       => __( 'تب های عمودی', 'flatsome-admin' ),
				'tabs_pills'          => __( 'پیلس', 'flatsome-admin' ),
				'tabs_outline'        => __( 'خارج خطی', 'flatsome-admin' ),
				'sections'            => __( 'بخش', 'flatsome-admin' ),
				'accordian'           => __( 'آکاردئون', 'flatsome-admin' ),
				'accordian-collapsed' => __( 'آکاردئون کول اپسد', 'flatsome-admin' ),
			),
		),
		'align' => array(
			'type'    => 'select',
			'heading' => 'موقعیت',
			'default' => 'left',
			'options' => array(
				'left'   => __( 'چپ', 'flatsome-admin' ),
				'center' => __( 'وسط', 'flatsome-admin' ),
				'right'  => __( 'راست', 'flatsome-admin' ),
			),
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_related', array(
	'name'      => __( 'محصولات مرتبط', 'flatsome' ),
	'category'  => __( 'برگه محصولات', 'flatsome' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_related' ),
	'options'   => array(
		'style' => array(
			'type'    => 'select',
			'heading' => 'استایل',
			'default' => 'slider',
			'options' => array(
				'slider' => __( 'اسلایدر', 'flatsome-admin' ),
				'grid'   => __( 'گرید', 'flatsome-admin' ),
			),
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_hook', array(
	'name'      => __( 'هوک های محصولات', 'flatsome' ),
	'category'  => __( 'برگه محصولات', 'flatsome' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_hooks' ),
	'options'   => array(
		'hook' => array(
			'type'    => 'select',
			'heading' => 'هوک',
			'default' => 'woocommerce_single_product_summary',
			'options' => apply_filters( 'flatsome_custom_product_single_product_hooks', array(
				'woocommerce_before_single_product_summary' => 'woocommerce_before_single_product_summary',
				'woocommerce_single_product_summary'        => 'woocommerce_single_product_summary',
				'woocommerce_after_single_product_summary'  => 'woocommerce_after_single_product_summary',
				'flatsome_custom_single_product_1'          => 'flatsome_custom_single_product_1',
				'flatsome_custom_single_product_2'          => 'flatsome_custom_single_product_2',
				'flatsome_custom_single_product_3'          => 'flatsome_custom_single_product_3',
			) ),
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_breadcrumbs', array(
	'name'      => __( 'برادکرامپ محصولات', 'flatsome' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_breadcrumbs' ),
	'category'  => __( 'برگه محصولات', 'flatsome' ),
	'options'   => array(
		'size' => array(
			'type'    => 'select',
			'heading' => 'سایز',
			'default' => '',
			'options' => $sizes,
		),
	),
) );

add_ux_builder_shortcode( 'ux_product_next_prev_nav', array(
	'name'      => __( 'محمصول بعدی/قبلی', 'flatsome' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'woo_next_prev' ),
	'category'  => __( 'برگه محصول', 'flatsome' ),
	'options'   => array(
		'class' => array(
			'type'    => 'textfield',
			'heading' => 'کلاس',
			'default' => '',
		),
	),
) );
