<?php

if ( ! isset( $repeater_posts ) ) $repeater_posts = 'posts';
if ( ! isset( $repeater_post_type ) ) $repeater_post_type = 'post';
if ( ! isset( $repeater_post_cat ) ) $repeater_post_cat = 'category';

return array(
    'type' => 'group',
    'heading' => __( 'مطالب', 'flatsome' ),
    'options' => array(

     'ids' => array(
        'type' => 'select',
        'heading' => 'مطالب',
        'param_name' => 'ids',
		'full_width' => true,
        'config' => array(
            'multiple' => true,
            'placeholder' => 'Select..',
            'postSelect' => array(
                'post_type' => array($repeater_post_type)
            ),
        )
    ),

    'cat' => array(
        'type' => 'select',
        'heading' => 'دسته بندی',
        'param_name' => 'cat',
		'full_width' => true,
        'conditions' => 'ids == ""',
        'default' => '',
        'config' => array(
            'multiple' => true,
            'placeholder' => 'Select...',
            'termSelect' => array(
                'post_type' => $repeater_post_cat,
                'taxonomies' => $repeater_post_cat
            ),
        )
    ),

    $repeater_posts => array(
        'type' => 'textfield',
        'heading' => 'مجموع مطالب',
        'conditions' => 'ids == ""',
        'default' => '8',
    ),

    'offset' => array(
        'type' => 'textfield',
        'heading' => 'آفست',
        'conditions' => 'ids == ""',
        'default' => '',
    ),

     'orderby'       => array(
	     'type'       => 'select',
	     'heading'    => 'مرتب سازی براساس',
	     'conditions' => 'ids == ""',
	     'default'    => 'date',
	     'options'    => array(
		     'ID'            => 'شناسه',
		     'title'         => 'عنوان',
		     'name'          => 'نام',
		     'date'          => 'تاریخ ساخته شده',
		     'modified'      => 'تاریخ بروزرسانی',
		     'rand'          => 'تصادفی',
		     'comment_count' => 'تعداد دیدگاه ها',
		     'menu_order'    => 'سفارش منو',
	     ),
     ),

     'order'         => array(
	     'type'       => 'select',
	     'heading'    => 'مرتب سازی',
	     'conditions' => 'ids == ""',
	     'default'    => 'DESC',
	     'options'    => array(
		     'ASC'  => 'صعودی',
		     'DESC' => 'نزولی',
	     ),
     ),

    'tags' => array(
	    'type'       => 'select',
	    'heading'    => 'برچسب',
	    'conditions' => 'ids == ""',
	    'full_width' => true,
	    'default'    => '',
	    'config'     => array(
		    'multiple'    => true,
		    'placeholder' => 'انتخاب...',
		    'termSelect'  => array(
			    'post_type'  => $repeater_post_type,
			    'taxonomies' => 'post_tag',
		    ),
	    ),
    ),

)
);
