<?php

add_ux_builder_shortcode( 'col', array(
    'type' => 'container',
    'name' => __( 'ستون', 'ux-builder' ),
    'category' => __( 'Layout', 'flatsome' ),
    'template' => flatsome_ux_builder_template( 'col.html' ),
    'tools' => 'shortcodes/col/col-tools.directive.html',
    'info' => '{{ span }}/12 {{ label }}',
    'require' => array( 'row' ),
    'wrap'   => false,
    'inline' => true,
    'nested' => true,
    'resize' => array( 'right' ),

    'presets' => array(
        array(
            'name' => __( 'پیشفرض', 'flatsome' ),
            'content' => '[col span="4" span__sm="12"][/col]',
        ),
    ),

    'options' => array(
	    'label' => array(
		    'full_width'  => true,
		    'type'        => 'textfield',
		    'heading'     => 'برچسب',
		    'placeholder' => 'برچسب ادمین را وارد نمایید..',
	    ),
        'span' => array(
            'type' => 'col-slider',
            'heading' => 'عرض',
            'full_width' => true,
            'responsive' => true,
            'auto_focus' => true,
            'default' => 12,
            'max' => 12,
            'min' => 1,
        ),

        'force_first' => array(
            'type' => 'select',
            'heading' => 'موقعیت را اجباری کنید',
            'default' => '',
            'options' => array(
                ''   => 'None',
                'medium' => 'در تبلت',
                'small'  => 'در موبایل'
            )
        ),

        'divider' => array(
            'type' => 'checkbox',
            'heading' => 'فاصله',
        ),

        'padding' => array(
            'type' => 'margins',
            'heading' => 'فاصله داخلی',
            'full_width' => true,
            'responsive' => true,
            'min' => 0,
            'max' => 200,
            'step' => 1,
        ),

        'margin' => array(
            'type' => 'margins',
            'heading' => 'فاصله خارجی ( مارجین )',
            'full_width' => true,
            'responsive' => true,
            'min' => -500,
            'max' => 500,
            'step' => 1,
        ),

        'align' => array(
            'type' => 'radio-buttons',
            'heading' => 'موقعیت متن',
            'default' => '',
            'options' => require( __DIR__ . '/values/align-radios.php' ),
        ),

        'bg_color' => array(
            'type' => 'colorpicker',
            'heading' => __( 'رنگ پس زمینه', 'flatsome' ),
            'format' => 'rgb',
            'alpha' => true,
            'position' => 'پایین راست',
            'helpers' => require( __DIR__ . '/helpers/colors.php' ),
        ),
	    'bg_radius' => array(
		    'type'    => 'slider',
		    'heading' => __( 'بگ گراند ردیوس', 'flatsome' ),
		    'unit'    => 'px',
		    'default' => 0,
		    'max'     => 100,
		    'min'     => 0,
	    ),
        'color' => array(
            'type' => 'radio-buttons',
            'heading' => 'رنگ',
            'default' => '',
            'options' => array(
                'light'   => array( 'title' => 'روشن'),
                ''  => array( 'title' => 'تاریک'),
            ),
        ),
	    'sticky' => array(
		    'type'    => 'radio-buttons',
		    'heading' => 'استیکی',
		    'default' => '',
		    'options' => array(
			    'true' => array( 'title' => 'روشن' ),
			    ''     => array( 'title' => 'خاموش' ),
		    ),
	    ),
	    'sticky_mode' => array(
		    'type'       => 'select',
		    'heading'    => 'حالت استیکی',
		    'conditions' => 'sticky === "true"',
		    'default'    => '',
		    'options'    => array(
			    ''           => 'CSS (نیتیو)',
			    'javascript' => 'JavaScript (نیتیو)',
		    ),
	    ),
        'text_depth' => array(
              'type' => 'slider',
              'heading' => __( 'سایه متن', 'flatsome' ),
              'default' => '0',
              'unit' => '+',
              'max' => '5',
              'min' => '0',
        ),

        'max_width' => array(
            'type' => 'scrubfield',
            'heading' => 'حداکثر عرض',
            'responsive' => true,
            'default' => '',
            'min' => '0'
        ),


        'animate' => array(
            'type' => 'select',
            'heading' => 'انیمیشن',
            'default' => 'none',
            'options' => require( __DIR__ . '/values/animate.php' ),
        ),

        'hover' => array(
            'type' => 'select',
            'heading' => 'هاور افکت',
            'options' => array(
                '' => 'None',
                'fade' => 'Fade In',
                'focus' => 'Focus',
                'blur' => 'Blur In',
            ),
        ),

        'tooltip' => array(
            'type' => 'textfield',
            'heading' => 'تولتیپ',
        ),

        'parallax' => array(
            'type' => 'slider',
            'vertical' => true,
            'heading' => 'پارالکس',
            'default' => 0,
            'max' => 10,
            'min' => -10,
        ),

        'depth' => array(
            'type' => 'slider',
            'vertical' => true,
            'heading' => 'عمق',
            'default' => 0,
            'max' => 5,
            'min' => 0,
        ),

        'depth_hover' => array(
            'type' => 'slider',
            'vertical' => true,
            'heading' => 'هاور دیپ',
            'default' => 0,
            'max' => 5,
            'min' => 0,
        ),
	    'border_options' => require( __DIR__ . '/commons/border.php' ),
        'advanced_options' => require( __DIR__ . '/commons/advanced.php'),
    ),
) );
