<?php

add_ux_builder_shortcode( 'button', array(
	'name'      => __( 'دکمه', 'ux-builder' ),
	'category'  => __( 'Content', 'ux-builder' ),
	'template'  => flatsome_ux_builder_template( 'button.html' ),
	'thumbnail' => flatsome_ux_builder_thumbnail( 'button' ),
	'info'      => '{{ text }}',
	'inline'    => true,
	'wrap'      => false,
	'priority'  => 1,
	'presets'   => array(
		array(
			'name'      => __( 'ساده', 'ux-builder' ),
			'thumbnail' => flatsome_ux_builder_thumbnail( 'button-simple' ),
			'content'   => '[button text="Click me!"]',
		),
		array(
			'name'      => __( 'گرد', 'ux-builder' ),
			'thumbnail' => flatsome_ux_builder_thumbnail( 'button-round' ),
			'content'   => '[button text="Click me!" radius="10"]',
		),
		array(
			'name'      => __( 'دایره', 'ux-builder' ),
			'thumbnail' => flatsome_ux_builder_thumbnail( 'button-circle' ),
			'content'   => '[button text="Click me!" radius="99"]',
		),
		array(
			'name'      => __( 'خط خارجی', 'ux-builder' ),
			'thumbnail' => flatsome_ux_builder_thumbnail( 'button-outline' ),
			'content'   => '[button text="Click me!" style="outline"]',
		),
		array(
			'name'      => __( 'خط خارجی گرد', 'ux-builder' ),
			'thumbnail' => flatsome_ux_builder_thumbnail( 'button-outline-round' ),
			'content'   => '[button text="Click me!" style="outline" radius="10"]',
		),
		array(
			'name'      => __( 'خط خارجی دایره ای', 'ux-builder' ),
			'thumbnail' => flatsome_ux_builder_thumbnail( 'button-outline-circle' ),
			'content'   => '[button text="Click me!" style="outline" radius="99"]',
		),
		array(
			'name'      => __( 'لینک ساده', 'ux-builder' ),
			'thumbnail' => flatsome_ux_builder_thumbnail( 'button-link' ),
			'content'   => '[button text="Click me!"  style="link"]',
		),
		array(
			'name'      => __( 'Underline', 'ux-builder' ),
			'thumbnail' => flatsome_ux_builder_thumbnail( 'button-underline' ),
			'content'   => '[button text="Click me!"  style="underline"]',
		),
		array(
			'name'      => __( 'CTA - Small', 'ux-builder' ),
			'thumbnail' => flatsome_ux_builder_thumbnail( 'button-call-to-action' ),
			'content'   => '[button text="Click me!" style="shade" depth="3" depth_hover="5" radius="5"]',
		),
		array(
			'name'      => __( 'CTA - Large', 'ux-builder' ),
			'thumbnail' => flatsome_ux_builder_thumbnail( 'button-call-to-action-large' ),
			'content'   => '[button text="Click me!" style="shade" size="larger" depth="4" depth_hover="5" radius="10"]',
		),
	),
	'options'   => array(
		'text'             => array(
			'type'       => 'textfield',
			'holder'     => 'button',
			'heading'    => 'متن',
			'param_name' => 'text',
			'focus'      => 'true',
			'value'      => 'Button',
			'default'    => '',
			'auto_focus' => true,
		),
		'letter_case'      => array(
			'type'    => 'radio-buttons',
			'heading' => 'سبک نمایش متن',
			'default' => '',
			'options' => array(
				''          => array( 'title' => 'ABC' ),
				'lowercase' => array( 'title' => 'Abc' ),
			),
		),
		'layout_options'   => array(
			'type'    => 'group',
			'heading' => 'چیدمان',
			'options' => array(
				'color'       => array(
					'type'    => 'select',
					'heading' => 'رنگ',
					'default' => 'primary',
					'options' => array(
						'primary'   => 'Primary',
						'secondary' => 'Secondary',
						'alert'     => 'Alert',
						'success'   => 'Success',
						'white'     => 'White',
					),
				),
				'style'       => array(
					'type'    => 'select',
					'heading' => 'استایل',
					'default' => '',
					'options' => array(
						''          => 'Default',
						'outline'   => 'Outline',
						'link'      => 'Simple',
						'underline' => 'Underline',
						'shade'     => 'Shade',
						'bevel'     => 'Bevel',
						'gloss'     => 'Gloss',
					),
				),
				'size'        => array(
					'type'    => 'select',
					'heading' => 'سایز',
					'options' => require __DIR__ . '/values/sizes.php',
				),
				'animate'     => array(
					'type'    => 'select',
					'heading' => 'Animate',
					'default' => 'none',
					'options' => require __DIR__ . '/values/animate.php',
				),
				'padding'     => array(
					'type'       => 'margins',
					'heading'    => 'Padding',
					'full_width' => true,
					'min'        => 0,
					'max'        => 200,
					'step'       => 1,
				),
				'radius'      => array(
					'type'    => 'slider',
					'class'   => '',
					'heading' => 'ردیوس',
					'default' => '0',
					'max'     => '99',
					'min'     => '0',
				),
				'depth'       => array(
					'type'    => 'slider',
					'class'   => '',
					'heading' => 'عمق',
					'default' => '0',
					'max'     => '5',
					'min'     => '0',
				),
				'depth_hover' => array(
					'type'       => 'slider',
					'class'      => '',
					'heading'    => 'Depth :hover',
					'param_name' => 'depth_hover',
					'default'    => '0',
					'max'        => '5',
					'min'        => '0',
				),
				'expand'      => array(
					'type'    => 'checkbox',
					'heading' => 'اکسپند',
				),
			),
		),
		'icon_options'     => array(
			'type'    => 'group',
			'heading' => 'آیکون',
			'options' => array(
				'icon'        => array(
					'type'    => 'select',
					'heading' => 'آیکون',
					'options' => require __DIR__ . '/values/icons.php',
				),
				'icon_pos'    => array(
					'conditions' => 'icon',
					'type'       => 'select',
					'heading'    => 'Position',
					'options'    => array(
						''     => 'Right',
						'left' => 'Left',
					),
				),
				'icon_reveal' => array(
					'conditions' => 'icon',
					'type'       => 'select',
					'heading'    => 'Visibility',
					'options'    => array(
						''     => 'Always visible',
						'true' => 'Visible on hover',
					),
				),
			),
		),
		'link_options'     => require __DIR__ . '/commons/links.php',
		'advanced_options' => require __DIR__ . '/commons/advanced.php',
	),
) );
