<?php

add_filter( 'ux_builder_meta_options', function ( $options, $post ) {
  if ( $post->post_type == 'page' ) {
    $options['_wp_page_template'] = array(
      'type' => 'select',
      'heading' => __( 'تمپلیت' ),
      'options' => ux_builder_get_page_templates( $post ),
      'reload' => true,
    );
    $options['_footer'] = array(
      'type' => 'select',
      'heading' => __( 'فوتر برگه' ),
      'reload' => true,
      'default' => '',
      'options' => array(
        '' => __( 'پیشفرض' ),
        'simple' => __( 'ساده' ),
        'transparent' => __( 'شفاف' ),
        'custom' => __( 'فوتر سفارشی' ),
        'disabled' => __( 'پنهان' ),
      ),
    );
  }

  if ( get_theme_support( 'post-thumbnails' ) ) {
    $options['_thumbnail_id'] = array(
      'type' => 'image',
      'heading' => __( 'تصویر ویژه' ),
      'reload' => true,
    );
  }

  return $options;
}, 10, 2 );
