<?php

Flatsome_Option::add_section( 'type',
	array(
		'title' => __( 'تایپوگرافی', 'flatsome-admin' ),
		'panel' => 'style',
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'     => 'checkbox',
		'settings' => 'disable_fonts',
		'label'    => __( 'غیرفعالسازی فونت', 'flatsome-admin' ),
		'section'  => 'type',
		'default'  => 0,
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'        => 'checkbox',
		'settings'    => 'google_fonts_cdn',
		'label'       => __( 'بارگذاری فونت گوگل از سی دی ان', 'flatsome-admin' ),
		'description' => '<strong>فعال کردن این مورد به دلیل مقررات GDPR توصیه نمی شود!</strong> <a href="https://docs.uxthemes.com/article/415-google-fonts" target="_blank" rel="noopener">بیشتر بخوانید</a>',
		'section'     => 'type',
		'default'     => 0,
		'active_callback' => array(
			array(
				'setting'  => 'disable_fonts',
				'operator' => '==',
				'value'    => false,
			),
		),
	)
);

Flatsome_Option::add_field( 'option', array(
	'type'            => 'custom',
	'settings'        => 'clear_typography_cache',
	'tooltip'         => 'Clear typography cache and locally downloaded font files.',
	'section'         => 'type',
	'default'         => '<button id="flatsome-customizer-clear-typography-cache" class="button-primary button" title="Clear typography cache">پاکسازی کش typography</button>',
	'active_callback' => array(
		array(
			'setting'  => 'disable_fonts',
			'operator' => '==',
			'value'    => false,
		),
		array(
			'setting'  => 'google_fonts_cdn',
			'operator' => '==',
			'value'    => false,
		),
	),
) );

Flatsome_Option::add_field( 'option',
	array(
		'type'        => 'select',
		'settings'    => 'googlefonts_font_display',
		'label'       => __( 'نوع فونت-نمایش فونت گوگل', 'flatsome-admin' ),
		'description' => 'Choose how Google Fonts will be loaded.',
		'tooltip'     => '<ul>
								<li><span style="font-weight: bold">auto</span> font display strategy is defined by the user agent</li>
								<li><span style="font-weight: bold">block</span> flash of invisible text until the font loads</li>
								<li><span style="font-weight: bold">swap</span> fallback font until custom font loads (flash of unstyled text)</li>
								<li><span style="font-weight: bold">fallback</span> between block and swap, invisible text for a short time</li>
								<li><span style="font-weight: bold">optional</span> like fallback, but the browser can decide to not use the custom font</li>
							</ul>',
		'default'     => 'swap',
		'section'         => 'type',
		'active_callback' => array(
			array(
				'setting'  => 'google_fonts_cdn',
				'operator' => '==',
				'value'    => true,
			),
			array(
				'setting'  => 'disable_fonts',
				'operator' => '==',
				'value'    => false,
			),
		),
		'choices'     => array(
			'auto'     => __( 'Auto', 'flatsome-admin' ),
			'block'    => __( 'Block', 'flatsome-admin' ),
			'swap'     => __( 'Swap', 'flatsome-admin' ),
			'fallback' => __( 'Fallback', 'flatsome-admin' ),
			'optional' => __( 'Optional', 'flatsome-admin' ),
		),
	)
);

Flatsome_Option::add_field( '',
	array(
		'type'     => 'custom',
		'settings' => 'custom_title_type_headings',
		'label'    => __( '', 'flatsome-admin' ),
		'section'  => 'type',
		'default'  => '<div class="options-title-divider">خط سربرگ</div>',
		'active_callback' => array(
			array(
				'setting'  => 'disable_fonts',
				'operator' => '==',
				'value'    => false,
			),
		),
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'        => 'typography',
		'settings'    => 'type_headings',
		'description' => 'این فونت برای تمام عناوین H1، H2، H3، H5، H6 است.',
		'label'       => esc_attr__( 'فونت', 'flatsome-admin' ),
		'section'     => 'type',
		'default'     => array(
			'font-family' => 'YekanBakh',
			'variant'     => '500',
		),
		'active_callback' => array(
			array(
				'setting'  => 'disable_fonts',
				'operator' => '==',
				'value'    => false,
			),
		),
	)
);


Flatsome_Option::add_field( '',
	array(
		'type'     => 'custom',
		'settings' => 'custom_title_type_base',
		'label'    => __( '', 'flatsome-admin' ),
		'section'  => 'type',
		'default'  => '<div class="options-title-divider">پایه</div>',
		'active_callback' => array(
			array(
				'setting'  => 'disable_fonts',
				'operator' => '==',
				'value'    => false,
			),
		),
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'     => 'typography',
		'settings' => 'type_texts',
		'label'    => esc_attr__( 'فونت متن پایه', 'flatsome-admin' ),
		'section'  => 'type',
		'default'  => array(
			'font-family' => 'Lato',
			'variant'     => 'regular',
		),
		'active_callback' => array(
			array(
				'setting'  => 'disable_fonts',
				'operator' => '==',
				'value'    => false,
			),
		),
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'        => 'slider',
		'settings'    => 'type_size',
		'label'       => __( 'اندازه فونت پایه', 'flatsome-admin' ),
		'section'     => 'type',
		'description' => 'اندازه فونت پایه را در %.',
		'default'     => 100,
		'choices'     => array(
			'min'  => 50,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'postMessage',
		'active_callback' => array(
			array(
				'setting'  => 'disable_fonts',
				'operator' => '==',
				'value'    => false,
			),
		),
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'        => 'slider',
		'settings'    => 'type_size_mobile',
		'label'       => __( 'اندازه قلم پایه موبایل', 'flatsome-admin' ),
		'section'     => 'type',
		'description' => 'اندازه فونت پایه موبایل را در آن تنظیم کنید %.',
		'default'     => 100,
		'choices'     => array(
			'min'  => 50,
			'max'  => 200,
			'step' => 1,
		),
		'transport'   => 'postMessage',
		'active_callback' => array(
			array(
				'setting'  => 'disable_fonts',
				'operator' => '==',
				'value'    => false,
			),
		),
	)
);

Flatsome_Option::add_field( '',
	array(
		'type'     => 'custom',
		'settings' => 'custom_title_type_nav',
		'label'    => __( '', 'flatsome-admin' ),
		'section'  => 'type',
		'default'  => '<div class="options-title-divider">نویگیشن</div>',
		'active_callback' => array(
			array(
				'setting'  => 'disable_fonts',
				'operator' => '==',
				'value'    => false,
			),
		),
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'      => 'typography',
		'settings'  => 'type_nav',
		'label'     => esc_attr__( 'فونت', 'flatsome-admin' ),
		'section'   => 'type',
		'default'   => array(
			'font-family' => 'YekanBakh',
			'variant'     => '500',
		),
		'active_callback' => array(
			array(
				'setting'  => 'disable_fonts',
				'operator' => '==',
				'value'    => false,
			),
		),
	)
);

Flatsome_Option::add_field( '',
	array(
		'type'     => 'custom',
		'settings' => 'custom_title_type_alt',
		'label'    => __( '', 'flatsome-admin' ),
		'section'  => 'type',
		'default'  => '<div class="options-title-divider">فونت ALT</div>',
		'active_callback' => array(
			array(
				'setting'  => 'disable_fonts',
				'operator' => '==',
				'value'    => false,
			),
		),
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'        => 'typography',
		'settings'    => 'type_alt',
		'description' => 'فونت Alt را می توان در منوی کشویی فرمت در ویرایشگر متن انتخاب کرد.',
		'label'       => esc_attr__( 'فونت Alt (.alt-font)', 'flatsome-admin' ),
		'section'     => 'type',
		'default'     => array(
			'font-family' => 'Dancing Script',
			'variant'     => 'regular',
		),
		'active_callback' => array(
			array(
				'setting'  => 'disable_fonts',
				'operator' => '==',
				'value'    => false,
			),
		),
	)
);

Flatsome_Option::add_field( '',
	array(
		'type'     => 'custom',
		'settings' => 'custom_title_type_transform',
		'label'    => __( '', 'flatsome-admin' ),
		'section'  => 'type',
		'default'  => '<div class="options-title-divider">متن ترانسفرم</div>',
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'      => 'radio-buttonset',
		'settings'  => 'text_transform_breadcrumbs',
		'label'     => esc_attr__( 'برادکرامپ', 'flatsome-admin' ),
		'section'   => 'type',
		'default'   => '',
		'choices'   => array(
			''     => 'آپرکیس',
			'none' => 'نرمال',
		),
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'      => 'radio-buttonset',
		'settings'  => 'text_transform_buttons',
		'label'     => esc_attr__( 'دکمه ها', 'flatsome-admin' ),
		'section'   => 'type',
		'default'   => '',
		'choices'   => array(
			''     => 'اپرکیس',
			'none' => 'نرمال',
		),
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'      => 'radio-buttonset',
		'settings'  => 'text_transform_navigation',
		'label'     => esc_attr__( 'نویگیشن / تب', 'flatsome-admin' ),
		'section'   => 'type',
		'default'   => '',
		'choices'   => array(
			''     => 'آپرکیس',
			'none' => 'نرمال',
		),
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'      => 'radio-buttonset',
		'settings'  => 'text_transform_section_titles',
		'label'     => esc_attr__( 'عنوان های بخش', 'flatsome-admin' ),
		'section'   => 'type',
		'default'   => '',
		'choices'   => array(
			''     => 'آپرکیس',
			'none' => 'نرمال',
		),
	)
);

Flatsome_Option::add_field( 'option',
	array(
		'type'      => 'radio-buttonset',
		'settings'  => 'text_transform_widget_titles',
		'label'     => esc_attr__( 'عنوان های ویجت', 'flatsome-admin' ),
		'section'   => 'type',
		'default'   => '',
		'choices'   => array(
			''     => 'آپرکیس',
			'none' => 'نرمال',
		),
	)
);
