<?php
/**
 * Advanced Theme Options
 *
 * @package Flatsome/Admin/Options/Advanced
 */

add_action( 'init', 'of_options' );

if ( ! function_exists( 'of_options' ) ) {
	/**
	 * Advance Theme Options.
	 *
	 * @global array $of_options Description.
	 *
	 * @return void.
	 */
	function of_options() {
		// Access the WordPress Categories via an Array.
		$of_categories     = array();
		$of_categories_obj = get_categories( 'hide_empty=0' );
		foreach ( $of_categories_obj as $of_cat ) {
			$of_categories[ $of_cat->cat_ID ] = $of_cat->cat_name;
		}

		// Access the WordPress Pages via an Array.
		$of_pages      = array();
		$of_pages_obj  = get_pages( 'sort_column=post_parent,menu_order' );
		$of_pages['0'] = 'یک برگه را انتخاب نمایید:';
		foreach ( $of_pages_obj as $of_page ) {
			$of_pages[ $of_page->ID ] = $of_page->post_title;
		}

		// Set the Options Array.
		global $of_options;
		$of_options = array();

		$of_options[] = array(
			'name' => '1- تنظیمات',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => 'اسکریپت های هدر',
			'desc' => 'اسکریپت های سفارشی را داخل تگ HEAD اضافه کنید. شما باید یک تگ SCRIPT در اطراف اسکریپت ها داشته باشید.',
			'id'   => 'html_scripts_header',
			'std'  => '',
			'type' => 'textarea',
		);

		$of_options[] = array(
			'name' => 'اسکریپت فوتر',
			'desc' => 'اسکریپت های سفارشی را که ممکن است بخواهید در پاورقی وب سایت خود بارگذاری شوند، اضافه کنید. شما باید یک تگ SCRIPT در اطراف اسکریپت ها داشته باشید.',
			'id'   => 'html_scripts_footer',
			'std'  => '',
			'type' => 'textarea',
		);

		$of_options[] = array(
			'name' => 'اسکریپت های بدنه - بالا',
			'desc' => 'اسکریپت های سفارشی را درست بعد از باز شدن تگ BODY اضافه کنید. شما باید یک تگ SCRIPT در اطراف اسکریپت ها داشته باشید.',
			'id'   => 'html_scripts_after_body',
			'std'  => '',
			'type' => 'textarea',
		);

		$of_options[] = array(
			'name' => 'اسکریپت های بدنه - پایین',
			'desc' => 'اسکریپت های سفارشی را درست قبل از بسته شدن تگ BODY اضافه کنید. شما باید یک تگ SCRIPT در اطراف اسکریپت ها داشته باشید.',
			'id'   => 'html_scripts_before_body',
			'std'  => '',
			'type' => 'textarea',
		);

		$of_options[] = array(
			'name' => 'پشتیبانی فلت سام 2.0 به بالا',
			'id'   => 'flatsome_fallback',
			'desc' => 'پشتیبانی از محتوای ساخته شده در Flatsome 2.0. برای افزایش سرعت سایت غیر فعال کنید.',
			'std'  => 1,
			'type' => 'checkbox',
		);

		$of_options[] = array(
			'name' => '2- css  سفارشی',
			'type' => 'heading',
			'label' => 'in test ast',
		);

		$of_options[] = array(
			'name' => 'تمامی اسکرین ها',
			'desc' => 'افزودن اسکرین های سی اس اس سفارشی',
			'id'   => 'html_custom_css',
			'std'  => '',
			'type' => 'textarea',
		);

		$of_options[] = array(
			'name' => 'تبلت ها و پایین',
			'desc' => 'CSS سفارشی را اینجا برای تبلت و موبایل اضافه کنید',
			'id'   => 'html_custom_css_tablet',
			'std'  => '',
			'type' => 'textarea',
		);

		$of_options[] = array(
			'name' => 'فقط موبایل',
			'desc' => 'CSS سفارشی را اینجا برای نمایش موبایل اضافه کنید',
			'id'   => 'html_custom_css_mobile',
			'std'  => '',
			'type' => 'textarea',
		);

		// Performance.
		$of_options[] = array(
			'name' => '3- عملکرد',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => '',
			'type' => 'info',
			'desc' => '<p style="font-size:14px">با احتیاط استفاده کنید! اگر مشکل سازگاری افزونه دارید غیرفعال کنید.</p>',
		);

		$of_options[] = array(
			'name' => 'از پیش بارگذاری صفحات',
			'id'   => 'perf_instant_page',
			'desc' => 'برای مرور سریع بین صفحات، درست قبل از اینکه کاربر روی آن کلیک کند، صفحات را از قبل بارگیری کنید.',
			'std'  => 0,
			'type' => 'checkbox',
		);

		$of_options[] = array(
			'name' => 'لیزی لود تصاویر',
			'id'   => 'lazy_load_images',
			'desc' => 'فعال کردن بارگذاری تنبل برای تصاویر. این یک تصویر خالی Base64 با نسبت تصویر مشابه با تصویر اصلی ایجاد می کند.',
			'std'  => 0,
			'type' => 'checkbox',
		);

		$of_options[] = array(
			'name' => 'تم style.css را غیرفعال کنید',
			'type' => 'checkbox',
			'id'   => 'flatsome_disable_style_css',
			'std'  => 0,
			'desc' => 'بارگیری تم style.css را غیرفعال کنید. این فایل تنها زمانی مورد نیاز است که CSS سفارشی را به آن فایل اضافه کرده باشید.',
		);

		$of_options[] = array(
			'name' => 'اسکریپت ایموجی را غیرفعال کنید',
			'type' => 'checkbox',
			'id'   => 'disable_emoji',
			'std'  => 0,
			'desc' => 'اسکریپت های ایموجی WP را از قسمت جلویی حذف کنید.',
		);

		$of_options[] = array(
			'name' => 'کتابخانه سی اس اس را غیرفعال کنید',
			'type' => 'checkbox',
			'id'   => 'disable_blockcss',
			'std'  => 0,
			'desc' => 'css کتابخانه بلوک پیش‌فرض که از وردپرس می‌آید را حذف کنید',
		);

		$of_options[] = array(
			'name' => 'jQuery میگرایت را غیرفعال کنید',
			'type' => 'checkbox',
			'id'   => 'jquery_migrate',
			'std'  => 0,
			'desc' => 'jQuery Migrate را حذف کنید. اکثر کدهای فرانت اند به روز و افزونه ها به jquery-migrate.min.js نیاز ندارند. اغلب اوقات، حفظ این - به سادگی بار غیر ضروری را به سایت شما اضافه می کند.',
		);

		// Content delivery.
		$of_options[] = array(
			'name' => '4- تحویل محتوا',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => '',
			'type' => 'info',
			'desc' => '<h2 style="font-size:1rem; margin-top: 40px;">بارگذاری اجاکس<span class="of-tag">تجربی</span></h2><p style="font-size:14px">بدون بارگیری مجدد کل صفحه، محتوا را از سرور واکشی کنید. این یک ویژگی آزمایشی است و ممکن است تغییر کند. <b>اگر با مشکلات سازگاری افزونه مواجه شدید، غیرفعال کنید.</b></p><p><a target="_blank" rel="noopener" href="https://docs.uxthemes.com/article/430-pjax">بیشتر بخوانید</a></p>',
		);

		$of_options[] = array(
			'name'    => 'صفحه بندی وبلاگ',
			'id'      => 'blog_pagination',
			'std'     => '',
			'type'    => 'select',
			'options' => array(
				''     => 'ناوبری معمولی',
				'ajax' => 'ناوبری AJAX',
			),
		);

		if ( is_woocommerce_activated() ) {
			$of_options[] = array(
				'name'    => 'صفحه بندی فروشگاه',
				'id'      => 'shop_pagination',
				'std'     => '',
				'type'    => 'select',
				'options' => array(
					''                => 'ناوبری معمولی',
					'ajax'            => 'ناوبری AJAX',
					'infinite-scroll' => 'اسکرول بی نهایت',
				),
			);

			$of_options[] = array(
				'name' => 'آرشیو فروشگاه',
				'id'   => 'shop_filter_widgets_pjax',
				'desc' => 'اجاکس را برای ویجت دسته محصول و ویجت‌های فیلتر فعال کنید',
				'std'  => 0,
				'type' => 'checkbox',
			);
		}

		$of_options[] = array(
			'name' => 'اسکرول به بالا',
			'id'   => 'pjax_scroll_to_top',
			'desc' => 'بعد از پیمایش اجاکس به بالا بروید',
			'std'  => 0,
			'type' => 'checkbox',
		);

		$of_options[] = array(
			'name' => '',
			'type' => '',
			'desc' => '<h2 style="font-size:1rem; margin-top: 40px;">تنظیمات اسکرول بی نهایت</h2>',
		);

		$of_options[] = array(
			'name'    => 'نوع در حال بارگیری',
			'id'      => 'infinite_scroll_loader_type',
			'desc'    => 'انیمیشن نوع بارگیری را انتخاب کنید یا روی دکمه کلیک کنید.',
			'std'     => 'spinner',
			'type'    => 'select',
			'options' => array(
				'button'  => 'دکمه (با کلیک)',
				'spinner' => 'اسپینر',
				'image'   => 'تصاویر سفارشی',
			),
		);

		$of_options[] = array(
			'name' => 'تصویر لودر سفارشی',
			'desc' => "یک تصویر بارگیری سفارشی را آپلود یا انتخاب کنید (برای بارگیری نوع «تصویر سفارشی»).",
			'id'   => 'infinite_scroll_loader_img',
			'std'  => '',
			'type' => 'upload',
		);

		$of_options[] = array(
			'name' => '5- لودر سایت',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name'    => '5- لودر سایت',
			'id'      => 'site_loader',
			'desc'    => 'هنگام بارگیری سایت، پوشش سایت بارگذار را فعال کنید.',
			'type'    => 'select',
			'std'     => '',
			'options' => array(
				''     => 'غیرفعالسازی',
				'home' => 'فعالسازی در برگه اصلی',
				'all'  => 'فعالسازی همه برگه ها',
			),
		);

		$of_options[] = array(
			'name'    => 'رنگ',
			'id'      => 'site_loader_color',
			'type'    => 'select',
			'std'     => 'light',
			'options' => array(
				'light' => 'روشن',
				'dark'  => 'تاریک',
			),
		);

		$of_options[] = array(
			'name' => 'رنگ پس زمینه',
			'id'   => 'site_loader_bg',
			'std'  => '',
			'type' => 'color',
		);

		$of_options[] = array(
			'name' => '6- جستجو سایت',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => 'جستجو زنده',
			'id'   => 'live_search',
			'desc' => 'جستجوی زنده برای محصولات، صفحات و پست ها را فعال کنید.',
			'std'  => 1,
			'type' => 'checkbox',
		);

		$of_options[] = array(
			'name' => 'متن نگهدارنده جستجو',
			'desc' => 'مکان‌دار فیلد جستجو را تغییر دهید.',
			'id'   => 'search_placeholder',
			'type' => 'text',
		);

		$of_options[] = array(
			'name'    => 'تأخیر نتایج جستجو',
			'desc'    => 'تأخیر را برای نتایج جستجوی زنده تنظیم کنید.',
			'id'      => 'search_result_latency',
			'std'     => '0',
			'type'    => 'select',
			'options' => array(
				'0'    => 'Instant',
				'500'  => '500 ms',
				'1000' => '1000 ms',
				'1500' => '1500 ms',
				'2000' => '2000 ms',
			),
		);

		if ( is_woocommerce_activated() ) {

			$of_options[] = array(
				'name' => 'نمایش وبلاگ و صفحات در نتایج جستجو',
				'id'   => 'search_result',
				'desc' => 'وبلاگ و صفحات را در نتایج جستجو فعال کنید.',
				'std'  => 1,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name'    => 'استایل لیست پست ها و صفحات',
				'id'      => 'search_result_style',
				'desc'    => 'نمایش نتایج به صورت ردیف، سنگ تراشی یا سبک اسلایدر.',
				'type'    => 'select',
				'std'     => 'slider',
				'options' => array(
					'row'     => 'سطر',
					'masonry' => 'ماسونری',
					'slider'  => 'اسلایدر',
				),
			);

			$of_options[] = array(
				'name'    => 'محصولات: مرتبط سازی براساس',
				'id'      => 'search_products_order_by',
				'type'    => 'select',
				'std'     => 'relevance',
				'options' => array(
					'relevance' => 'ارتباط',
					'title'     => 'عنوان',
					'price'     => 'قیمت',
				),
			);

			$of_options[] = array(
				'name'    => 'محصولات: به ترتیب',
				'id'      => 'search_products_order',
				'type'    => 'select',
				'std'     => 'ASC',
				'options' => array(
					'ASC'  => 'صعودی',
					'DESC' => 'نزولی',
				),
			);

			$of_options[] = array(
				'name' => 'شناسه محصول را جستجو کنید',
				'desc' => 'امکان جستجو بر اساس شناسه در جستجوی زنده.',
				'id'   => 'search_by_sku',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => 'جستجوی برچسب محصول',
				'desc' => 'امکان جستجو بر اساس برچسب های محصول در جستجوی زنده.',
				'id'   => 'search_by_product_tag',
				'std'  => 0,
				'type' => 'checkbox',
			);
		}

		$of_options[] = array(
			'name' => '7- اینستاگرام',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => 'فید تنظیمات',
			'id'   => 'instagram_lazy_load',
			'desc' => 'وقتی فیدهای اینستاگرام در نمای نمایش ظاهر می شوند، تنبلی بارگذاری می شوند.',
			'std'  => 0,
			'type' => 'checkbox',
		);

		$of_options[] = array(
			'name' => 'اکانت',
			'std'  => flatsome_facebook_accounts_html(),
			'type' => 'info',
		);

		$of_options[] = array(
			'name' => 'کش',
			'std'  => flatsome_facebook_cache_html(),
			'type' => 'info',
		);

		$of_options[] = array(
			'name' => 'بیزنس اکانت',
			'desc' => flatsome_facebook_login_button_html(),
			'type' => 'info',
		);

		$of_options[] = array(
			'name' => '8- گوگل API',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => 'نقشه  گوگل API',
			'desc' => "کلید Google Maps API را در اینجا وارد کنید تا Maps فعال شود. شما می توانید یکی را در اینجا ایجاد کنید: <a target='_blank' href='https://developers.google.com/maps/documentation/javascript/get-api-key'>گوگل مپ API</a>",
			'id'   => 'google_map_api',
			'std'  => '',
			'type' => 'text',
		);

		$maintenance_mode = apply_filters( 'flatsome_maintenance_mode', [ 'access_mode' => 'roles' ] );

		$of_options[] = array(
			'name' => '9- حالت تعمیر و نگهداری',
			'type' => 'heading',
		);

		if ( ! empty( $maintenance_mode['access_mode'] ) ) {
			$access_mode = $maintenance_mode['access_mode'];

			$supported_modes = [ 'logged_in', 'roles', 'current_user_can' ];
			$display_mode    = in_array( $access_mode, $supported_modes, true )
				? $access_mode
				: sprintf( '%s (پشتیبانی نشده)', $access_mode );

			$of_options[] = array(
				'name' => '',
				'type' => 'info',
				'desc' => sprintf( '<p style="font-size:14px">وضعیت دسترسی: %s</p>', $display_mode ),
			);
		}

		$of_options[] = array(
			'name' => 'حالت تعمیر و نگهداری',
			'id'   => 'maintenance_mode',
			'desc' => 'حالت تعمیر و نگهداری را فعال کنید.',
			'std'  => 0,
			'type' => 'checkbox',
		);

		if ( ! empty( $maintenance_mode['access_mode'] && $maintenance_mode['access_mode'] === 'roles' ) ) {
			$of_options[] = array(
				'name'    => 'حذف نقش ها',
				'id'      => 'maintenance_mode_excluded_roles',
				'desc'    => 'نقش‌ها را از حالت نگهداری حذف کنید (ادمین همیشه دسترسی دارد).',
				'std'     => array(),
				'type'    => 'multicheck',
				'options' => flatsome_get_role_list( array(
					'exclude' => array(
						'super_admin',
						'administrator',
					),
				) ),
			);
		}

		$of_options[] = array(
			'name' => 'کلید دور زدن',
			'id'   => 'maintenance_mode_bypass_key',
			'desc' => 'یک کلید منحصر به فرد را در اینجا وارد کنید. این کلید وقتی به عنوان پارامتر در URL اضافه می شود، به کاربر اجازه می دهد تا حالت تعمیر و نگهداری را دور بزند و به وب سایت دسترسی پیدا کند. برای مثال، اگر «key1234» را به‌عنوان کلید وارد کنید، می‌توانید با اضافه کردن کلید f.ex، حالت تعمیر و نگهداری را در هر URL دور بزنید: https://example.com/?key1234 یا https://example.com/shop /?key1234 و غیره',
			'std'  => '',
			'type' => 'text',
		);

		$of_options[] = array(
			'name' => 'اطلاعیه مدیریت',
			'id'   => 'maintenance_mode_admin_notice',
			'desc' => 'وقتی حالت تعمیر و نگهداری فعال است، اطلاعیه سرپرست را نشان دهید.',
			'std'  => 1,
			'type' => 'checkbox',
		);

		$of_options[] = array(
			'name'    => 'صفحه تعمیر و نگهداری سفارشی',
			'id'      => 'maintenance_mode_page',
			'desc'    => 'یک صفحه سفارشی را به عنوان صفحه تعمیر و نگهداری تنظیم کنید. فقط این صفحه برای بازدیدکنندگان قابل مشاهده خواهد بود.',
			'std'     => 0,
			'type'    => 'select',
			'options' => $of_pages,
		);

		$of_options[] = array(
			'name' => 'متن حالت نگهداری',
			'desc' => 'متنی که هنگام دسترسی به صفحه تعمیر و نگهداری برای مشتریان شما قابل مشاهده خواهد بود.',
			'id'   => 'maintenance_mode_text',
			'std'  => 'لطفا به زودی دوباره بررسی کنید..',
			'type' => 'text',
		);

		$of_options[] = array(
			'name' => '10- برگه 404',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name'    => 'بلوک سفارشی 404',
			'id'      => '404_block',
			'desc'    => 'محتوای صفحه 404 را با یک بلوک سفارشی جایگزین کنید که می توانید آن را در صفحه ساز ویرایش کنید.',
			'std'     => 0,
			'type'    => 'select',
			'options' => flatsome_get_block_list_by_id( array( 'option_none' => '-- None --' ) ),
		);

		if ( is_woocommerce_activated() ) {

			$of_options[] = array(
				'name' => '11- ووکامرس',
				'type' => 'heading',
			);

			$of_options[] = array(
				'name' => 'محصولات متغیر',
				'id'   => 'swatches',
				'desc' => 'نمونه های تنوع را فعال کنید.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'id'   => 'additional_variation_images',
				'desc' => 'فعال کردن تصاویر تنوع اضافی (گالری فلت سام).',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => 'محصول تکی',
				'id'   => 'ajax_add_to_cart',
				'desc' => 'دکمه های افزودن به سبد خرید AJAX را در صفحه تک محصول و مشاهده سریع فعال کنید.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => 'مرورهای جهانی را غیرفعال کنید',
				'id'   => 'disable_reviews',
				'desc' => 'بررسی های جهانی را غیرفعال کنید.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => 'گالری محصولات ووکامرس',
				'id'   => 'product_gallery_woocommerce',
				'desc' => 'برای سازگاری افزونه ها از نوار لغزنده گالری ووکامرس پیش فرض استفاده کنید. <br>(با این کار گالری محصول Flatsome و چندین گزینه برای آن غیرفعال می شود)',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => 'هدر فروشگاه',
				'desc' => 'HTML را وارد کنید که باید در بالای صفحه اصلی فروشگاه قرار گیرد. کد کوتاه مجاز است. ',
				'id'   => 'html_shop_page',
				'std'  => '',
				'type' => 'textarea',
			);

			$of_options[] = array(
				'name' => 'عنوان زبانه/بخش جهانی اضافی',
				'id'   => 'tab_title',
				'std'  => '',
				'type' => 'text',
			);

			$of_options[] = array(
				'name' => 'محتوای برگه/بخش جهانی اضافی',
				'id'   => 'tab_content',
				'std'  => '',
				'type' => 'textarea',
				'desc' => 'محتوای برگه اضافی را در اینجا اضافه کنید ... مانند نمودار اندازه و غیره.',
			);

			$of_options[] = array(
				'name' => 'HTML قبل از دکمه افزودن به سبد خرید (کلی)',
				'desc' => 'HTML و کدهای کوتاهی را وارد کنید که قبل از انتخاب های افزودن به سبد خرید نشان داده می شوند.',
				'id'   => 'html_before_add_to_cart',
				'std'  => ' ',
				'type' => 'textarea',
			);

			$of_options[] = array(
				'name' => 'HTML بعد از دکمه افزودن به سبد خرید (کلی)',
				'desc' => 'HTML و کدهای کوتاه را وارد کنید که بعد از دکمه افزودن به سبد خرید نشان داده می شوند.',
				'id'   => 'html_after_add_to_cart',
				'std'  => '',
				'type' => 'textarea',
			);

			$of_options[] = array(
				'name' => 'با تشکر از شما محتوای صفحه / اسکریپت',
				'desc' => 'اسکریپت ها یا محتوای HTML سفارشی را برای صفحه تشکر در اینجا وارد کنید',
				'id'   => 'html_thank_you',
				'std'  => '',
				'type' => 'textarea',
			);

			$of_options[] = array(
				'name' => '12- حالت کاتالوگ',
				'type' => 'heading',
			);

			$of_options[] = array(
				'name' => 'حالت کاتالوگ را فعال کنید',
				'id'   => 'catalog_mode',
				'desc' => 'حالت کاتالوگ را فعال کنید. این کار دکمه های افزودن به سبد خرید / پرداخت و سبد خرید را غیرفعال می کند.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => 'غیرفعال کردن قیمت ها',
				'id'   => 'catalog_mode_prices',
				'desc' => 'برای غیرفعال کردن قیمت ها در صفحات دسته بندی و صفحه محصول انتخاب کنید.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => 'حذف نشان فروش',
				'id'   => 'catalog_mode_sale_badge',
				'desc' => 'برای حذف نشان های فروش انتخاب کنید.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => 'تعویض سبد خرید / حساب (سربرگ)',
				'id'   => 'catalog_mode_header',
				'std'  => '',
				'type' => 'textarea',
				'desc' => "محتوایی را که می خواهید نمایش دهید به جای حساب / سبد خرید وارد کنید. کد کوتاه مجاز است. برای کادر جستجو <b>[جستجو]</b> را وارد کنید. برای نمادهای اجتماعی وارد کنید: <b>[twitter='http://' facebook='http://' email='post@email.com' pinterest='http://']</b>",
			);

			$of_options[] = array(
				'name' => 'افزودن به سبد خرید تعویض - صفحه محصول',
				'id'   => 'catalog_mode_product',
				'std'  => '',
				'type' => 'textarea',
				'desc' => 'اطلاعات تماس یا کد کوتاه فرم درخواست را در اینجا وارد کنید.',
			);

			$of_options[] = array(
				'name' => 'افزودن به سبد خرید تعویض - نمایش سریع محصول',
				'id'   => 'catalog_mode_lightbox',
				'std'  => '',
				'type' => 'textarea',
				'desc' => 'متنی را وارد کنید که در نمای سریع محصول نشان داده شود',
			);
		}

		// Portfolio.
		$of_options[] = array(
			'name' => '13- نمونه کار',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => 'فعالسازی نمونه کار',
			'id'   => 'fl_portfolio',
			'desc' => 'ففعالسازی نمونه کار',
			'std'  => 1,
			'type' => 'checkbox',
		);

		// Mobile.
		$of_options[] = array(
			'name' => '14- موبایل',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => 'پشتیبانی از موبایل پارالکس',
			'id'   => 'parallax_mobile',
			'desc' => 'پارالاکس را برای دستگاه های تلفن همراه فعال کنید',
			'std'  => 0,
			'type' => 'checkbox',
		);

		// Integrations.
		$of_options[] = array(
			'name' => '15- سازگاری',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => '',
			'type' => 'info',
			'desc' => '<p style="font-size:14px">گزینه های اضافی برای افزونه های یکپارچه در صورت فعال شدن در اینجا نشان داده می شود.</p>',
		);

		$of_options[] = array(
			'name' => 'فلت‌سام استادیو',
			'id'   => 'flatsome_studio',
			'desc' => 'دسترسی به فلت سام استادیو را در UX Builder فعال کنید',
			'std'  => 1,
			'type' => 'checkbox',
		);

		if ( function_exists( 'ubermenu' ) ) {
			$of_options[] = array(
				'name' => 'اوبر منو',
				'id'   => 'flatsome_uber_menu',
				'desc' => 'اوبرمنو با عرض کامل را فعال کنید. همچنین می توانید با استفاده از گزینه های اوبر منو این را در جای دیگری وارد کنید.',
				'std'  => 1,
				'type' => 'checkbox',
			);
		}

		// Yoast options.
		if ( class_exists( 'WPSEO_Options' ) ) {
			$of_options[] = array(
				'name' => 'یوآست پرو دسته بندی',
				'id'   => 'wpseo_primary_term',
				'desc' => 'در صفحات و عناصر دسته بندی محصول استفاده کنید.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => '',
				'id'   => 'wpseo_manages_product_layout_priority',
				'desc' => 'اولویت طرح بندی محصول سفارشی را مدیریت کنید.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name'  => 'یوآست بروکرامپ',
				'id'    => 'wpseo_breadcrumb',
				'desc'  => 'در صفحات دسته بندی محصول، صفحات تک محصول و عناصر استفاده کنید.',
				'std'   => 0,
				'folds' => 1,
				'type'  => 'checkbox',
			);

			$of_options[] = array(
				'name' => '',
				'id'   => 'wpseo_breadcrumb_remove_last',
				'desc' => 'حذف آخرین خرده استاتیک در صفحات تک محصول (عنوان محصول).',
				'std'  => 1,
				'fold' => 'wpseo_breadcrumb',
				'type' => 'checkbox',
			);
		}

		// Rank Math options.
		if ( class_exists( 'RankMath' ) ) {
			$of_options[] = array(
				'name' => 'دسته بندی رنک مث پرو',
				'id'   => 'rank_math_primary_term',
				'desc' => 'در صفحات و عناصر دسته بندی محصول استفاده کنید.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => '',
				'id'   => 'rank_math_manages_product_layout_priority',
				'desc' => 'اولویت طرح بندی محصول سفارشی را مدیریت کنید.',
				'std'  => 0,
				'type' => 'checkbox',
			);

			$of_options[] = array(
				'name' => 'رنک مث برودکرامپ',
				'id'   => 'rank_math_breadcrumb',
				'desc' => 'در صفحات دسته بندی محصول، صفحات تک محصول و عناصر استفاده کنید.',
				'std'  => 0,
				'type' => 'checkbox',
			);
		}

		// All in one SEO options.
		if ( class_exists( 'پلاگین آل این وان سئو' ) ) {
			$of_options[] = array(
				'name' => 'AIOSEO برودکرامپ',
				'id'   => 'aioseo_breadcrumb',
				'desc' => 'در صفحات دسته بندی محصول، صفحات تک محصول و عناصر استفاده کنید.',
				'std'  => 0,
				'type' => 'checkbox',
			);
		}

		// SEOPress options.
		if ( defined( 'SEOPRESS_VERSION' ) ) {
			$of_options[] = array(
				'name' => defined( 'SEOPRESS_PRO_VERSION' ) ? 'سئو پر برادکرامپ' : 'سئو پرس برودکرامپ (سئو پرس پرو برادکرامپ)',
				'id'   => 'wpseopress_breadcrumb',
				'desc' => 'در صفحات دسته بندی محصول، صفحات تک محصول و عناصر استفاده کنید.',
				'std'  => 0,
				'type' => 'checkbox',
			);
		}

		// Updates.
		$of_options[] = array(
			'name' => '16- بروزرسانی',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name'    => 'کانال ریلز',
			'id'      => 'release_channel',
			'std'     => 'stable',
			'type'    => 'select',
			'options' => array(
				'stable' => 'ایستا',
				'beta'   => 'بتا',
			),
		);

		$of_options[] = array(
			'name' => '',
			'type' => 'warning',
			'desc' => '<p style="font-size:14px">با احتیاط استفاده کنید. از نسخه های پیش از انتشار در سایت های تولیدی استفاده نکنید. نسخه های بتا ممکن است پایدار نباشند.</p>',
		);

		// Backup Options.
		$of_options[] = array(
			'name' => '17- بکاپ و ایمپورت',
			'type' => 'heading',
		);

		$of_options[] = array(
			'name' => 'گزینه های پشتیبان گیری و بازیابی',
			'id'   => 'of_backup',
			'std'  => '',
			'type' => 'backup',
			'desc' => 'می‌توانید از دکمه‌های بالا برای پشتیبان‌گیری از گزینه‌های فعلی‌تان استفاده کنید و بعداً آن را بازیابی کنید. اگر می‌خواهید روی گزینه‌ها آزمایش کنید، اما می‌خواهید تنظیمات قدیمی را در صورت نیاز به بازگشت، حفظ کنید، این کار مفید است.',
		);

		$of_options[] = array(
			'name' => 'انتقال داده های گزینه های تم',
			'id'   => 'of_transfer',
			'std'  => '',
			'type' => 'transfer',
			'desc' => 'می توانید با کپی کردن متن داخل کادر متن، داده های گزینه های ذخیره شده را بین نصب های مختلف انتقال دهید. برای وارد کردن داده‌ها از نصب دیگری، داده‌های موجود در جعبه متن را با یکی از نصب‌های دیگر جایگزین کنید و روی «وارد کردن گزینه‌ها» کلیک کنید.".',
		);

	} // End of 'of_options()' function.
} // End check if function exists: of_options()
